/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.IOException;

@TargetClass(className="java.io.FileCleanable", onlyWith={JDK9OrLater.class})
final class Target_java_io_FileCleanable {
    Target_java_io_FileCleanable() {
    }

    @Substitute
    private static void cleanupClose0(int fd, long handle) throws IOException {
        if (fd != -1 && Unistd.close(fd) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("close failed");
        }
    }
}

