/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.Unistd;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class NativeImageServerHelper {
    @Fold
    public static boolean isInConfiguration() {
        return Platform.includedIn(InternalPlatform.LINUX_AND_JNI.class) || Platform.includedIn(InternalPlatform.DARWIN_AND_JNI.class);
    }

    @Platforms(value={InternalPlatform.LINUX_AND_JNI.class, InternalPlatform.DARWIN_AND_JNI.class})
    static int daemonize(Runnable runnable) {
        int pid = Unistd.fork();
        switch (pid) {
            case 0: {
                break;
            }
            default: {
                return pid;
            }
        }
        Unistd.setsid();
        runnable.run();
        System.exit(0);
        return -1;
    }
}

