/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import java.util.Arrays;
import java.util.function.Supplier;

public class AccessAdvisor {
    private boolean ignoreInternalAccesses = true;
    private boolean isInLivePhase = false;
    private int launchPhase = 0;

    public void setIgnoreInternalAccesses(boolean enabled) {
        this.ignoreInternalAccesses = enabled;
    }

    public void setInLivePhase(boolean live) {
        this.isInLivePhase = live;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isInternalClass(String qualifiedClass) {
        assert (qualifiedClass == null || qualifiedClass.indexOf(47) == -1) : "expecting Java-format qualifiers, not internal format";
        if (qualifiedClass == null) return false;
        if (!Arrays.asList("java.", "javax.", "sun.", "com.sun.", "jdk.", "org.graalvm.compiler.").stream().anyMatch(qualifiedClass::startsWith)) return false;
        return true;
    }

    public boolean shouldIgnore(Supplier<String> callerClass) {
        return this.ignoreInternalAccesses && (!this.isInLivePhase || AccessAdvisor.isInternalClass(callerClass.get()));
    }

    public boolean shouldIgnoreJniMethodLookup(Supplier<String> queriedClass, Supplier<String> name, Supplier<String> signature, Supplier<String> callerClass) {
        if (!this.ignoreInternalAccesses) {
            return false;
        }
        if (this.shouldIgnore(callerClass)) {
            return true;
        }
        if ("sun.launcher.LauncherHelper".equals(queriedClass.get())) {
            if (this.launchPhase == 0 && "getApplicationClass".equals(name.get()) && "()Ljava/lang/Class;".equals(signature.get())) {
                this.launchPhase = 1;
            }
            return true;
        }
        if (this.launchPhase == 1 && "getCanonicalName".equals(name.get()) && "()Ljava/lang/String;".equals(signature.get())) {
            this.launchPhase = 2;
            return true;
        }
        if (this.launchPhase > 0) {
            this.launchPhase = -1;
            if ("main".equals(name.get()) && "([Ljava/lang/String;)V".equals(signature.get())) {
                return true;
            }
        }
        return false;
    }
}

