/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;

public class ConfigurationTool {
    private static final String HELP_TEXT = ConfigurationTool.getResource("/Help.txt") + System.lineSeparator();

    public static void main(String[] args) {
        try {
            String first;
            if (args.length == 0) {
                throw new UsageException("No arguments provided.");
            }
            Iterator<String> argsIter = Arrays.asList(args).iterator();
            switch (first = argsIter.next()) {
                case "generate": {
                    ConfigurationTool.generate(argsIter, false);
                    break;
                }
                case "process-trace": {
                    ConfigurationTool.generate(argsIter, true);
                    break;
                }
                case "help": 
                case "--help": {
                    System.out.println(HELP_TEXT);
                    break;
                }
                default: {
                    throw new UsageException("Unknown subcommand: " + first);
                }
            }
        }
        catch (UsageException e) {
            System.err.println(e.getMessage() + System.lineSeparator() + "Use 'native-image-configure help' for usage.");
            System.exit(2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Path requirePath(String current, String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new UsageException("Argument must be provided for: " + current);
        }
        return Paths.get(value, new String[0]);
    }

    private static URI requirePathUri(String current, String value) {
        return ConfigurationTool.requirePath(current, value).toUri();
    }

    private static void generate(Iterator<String> argsIter, boolean acceptTraceFileArgs) throws IOException {
        JsonWriter writer;
        Object object;
        TraceProcessor p;
        ArrayList<URI> traceInputs = new ArrayList<URI>();
        boolean filter = true;
        ConfigurationSet inputSet = new ConfigurationSet();
        ConfigurationSet outputSet = new ConfigurationSet();
        block78: while (argsIter.hasNext()) {
            String[] parts = argsIter.next().split("=", 2);
            String current = parts[0];
            String value = parts.length > 1 ? parts[1] : null;
            ConfigurationSet set = outputSet;
            switch (current) {
                case "--input-dir": {
                    inputSet.addDirectory(ConfigurationTool.requirePath(current, value));
                    continue block78;
                }
                case "--output-dir": {
                    Path directory = ConfigurationTool.requirePath(current, value);
                    if (!Files.exists(directory, new LinkOption[0])) {
                        Files.createDirectory(directory, new FileAttribute[0]);
                    } else if (!Files.isDirectory(directory, new LinkOption[0])) {
                        throw new NoSuchFileException(value);
                    }
                    outputSet.addDirectory(directory);
                    continue block78;
                }
                case "--reflect-input": {
                    set = inputSet;
                }
                case "--reflect-output": {
                    set.getReflectConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block78;
                }
                case "--jni-input": {
                    set = inputSet;
                }
                case "--jni-output": {
                    set.getJniConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block78;
                }
                case "--proxy-input": {
                    set = inputSet;
                }
                case "--proxy-output": {
                    set.getProxyConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block78;
                }
                case "--resource-input": {
                    set = inputSet;
                }
                case "--resource-output": {
                    set.getResourceConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block78;
                }
                case "--trace-input": {
                    traceInputs.add(ConfigurationTool.requirePathUri(current, value));
                    continue block78;
                }
                case "--no-filter": {
                    filter = false;
                    continue block78;
                }
                case "--": {
                    if (acceptTraceFileArgs) {
                        argsIter.forEachRemaining(arg -> traceInputs.add(Paths.get(arg, new String[0]).toUri()));
                        continue block78;
                    }
                    throw new UsageException("Unknown argument: " + current);
                }
            }
            if (!acceptTraceFileArgs || current.startsWith("-")) {
                throw new UsageException("Unknown argument: " + current);
            }
            traceInputs.add(Paths.get(current, new String[0]).toUri());
        }
        try {
            p = new TraceProcessor(inputSet.loadJniConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadReflectConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadProxyConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadResourceConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        p.setFilterEnabled(filter);
        if (traceInputs.isEmpty() && inputSet.isEmpty()) {
            throw new UsageException("No inputs specified.");
        }
        for (URI uri : traceInputs) {
            BufferedReader reader = Files.newBufferedReader(Paths.get(uri));
            object = null;
            try {
                p.process(reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader == null) continue;
                if (object != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        if (outputSet.isEmpty()) {
            System.err.println("Warning: no outputs specified, validating inputs only.");
        }
        for (URI uri : outputSet.getReflectConfigPaths()) {
            writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            object = null;
            try {
                p.getReflectionConfiguration().printJson(writer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer == null) continue;
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getJniConfigPaths()) {
            writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            object = null;
            try {
                p.getJniConfiguration().printJson(writer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer == null) continue;
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getProxyConfigPaths()) {
            writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            object = null;
            try {
                p.getProxyConfiguration().printJson(writer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer == null) continue;
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getResourceConfigPaths()) {
            writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            object = null;
            try {
                p.getResourceConfiguration().printJson(writer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer == null) continue;
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResource(String resourceName) {
        try (InputStream input = ConfigurationTool.class.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            VMError.shouldNotReachHere((Throwable)e);
            return null;
        }
    }

    private static class UsageException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        UsageException(String message) {
            super(message);
        }
    }
}

