/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.BasicElementImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicProgbitsSectionImpl
extends BasicElementImpl
implements ObjectFile.ProgbitsSectionImpl {
    private byte[] content;

    public BasicProgbitsSectionImpl(byte[] content) {
        this(content, null);
    }

    public BasicProgbitsSectionImpl(ObjectFile.Section s) {
        this(new byte[0], s);
    }

    public BasicProgbitsSectionImpl(byte[] content, ObjectFile.Section s) {
        super(s);
        this.content = content;
    }

    public BasicProgbitsSectionImpl() {
    }

    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return ObjectFile.minimalDependencies(decisions, this.getElement());
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.content.length;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.content;
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return this.content.length;
    }

    @Override
    public int getAlignment() {
        return this.getElement().getAlignment();
    }

    @Override
    public void setContent(byte[] c) {
        this.content = c;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public ObjectFile.Section getElement() {
        return (ObjectFile.Section)super.getElement();
    }

    public List<ObjectFile.Section> getElements() {
        return Collections.singletonList(this.getElement());
    }

    @Override
    public ObjectFile.RelocationRecord markRelocationSite(int offset, int length, ObjectFile.RelocationKind k, String symbolName, boolean useImplicitAddend, Long explicitAddend) {
        return ((ObjectFile.RelocatableSectionImpl)((Object)this.getElement())).markRelocationSite(offset, length, ByteBuffer.wrap(this.getContent()).order(this.getOwner().getByteOrder()), k, symbolName, useImplicitAddend, explicitAddend);
    }

    @Override
    public final ObjectFile.RelocationRecord markRelocationSite(int offset, int length, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, boolean useImplicitAddend, Long explicitAddend) {
        assert (this.getContent() == null || bb.array() == this.getContent());
        return ((ObjectFile.RelocatableSectionImpl)((Object)this.getElement())).markRelocationSite(offset, length, bb, k, symbolName, useImplicitAddend, explicitAddend);
    }

    @Override
    public ObjectFile.Element getOrCreateRelocationElement(boolean useImplicitAddend) {
        return ((ObjectFile.RelocatableSectionImpl)((Object)this.getElement())).getOrCreateRelocationElement(useImplicitAddend);
    }

    @Override
    public boolean isLoadable() {
        return true;
    }
}

