/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.jndi.JndiAttrs;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    static final List<String> SERVER_MODES;
    private boolean newSyntax = true;
    public boolean connection_revised = false;
    public boolean connection_redirected = false;
    private String TNSAddress;
    private static final boolean DEBUG = false;
    private static final Pattern pattern;
    static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))";
    static final String CID_FORMAT = "(CID=(PROGRAM=%s)(HOST=__jdbc__)(USER=%s))";
    static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s)";
    static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s)";
    static final String SERVERMODE_FORMAT = "(SERVER=%s)";
    static final String EMPTY_STRING = "";
    static final String SID_KEY = "(SID=%s)";
    static final String SERVICE_NAME_KEY = "(SERVICE_NAME=%s)";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String string, Properties properties) throws NetException {
        String string2;
        this.up = properties;
        this.TNSAddress = string;
        if (string.startsWith("ldap:") || string.startsWith("ldaps:")) {
            boolean bl = false;
            Vector<String> vector = null;
            if (string.startsWith("ldap:") || string.startsWith("ldaps:")) {
                vector = this.computeLdapList(string);
                if (vector.size() > 1) {
                    bl = true;
                } else {
                    int n2 = string.lastIndexOf(47);
                    if (n2 == -1) {
                        throw new NetException(124);
                    }
                    this.up.put("java.naming.provider.url", string.substring(0, n2));
                    this.TNSAddress = string.substring(n2 + 1, string.length());
                }
            }
            if (!bl) {
                String[] stringArray = new String[1];
                JndiAttrs jndiAttrs = new JndiAttrs(this.up);
                stringArray[0] = service_attr_name;
                Vector vector2 = null;
                try {
                    vector2 = jndiAttrs.getAttrs(this.TNSAddress, stringArray);
                }
                finally {
                    jndiAttrs.close();
                }
                this.TNSAddress = (String)vector2.firstElement();
                this.connection_revised = true;
            } else {
                this.processLdapFailoverLoadblance(vector);
            }
        }
        if ((string2 = this.up.getProperty("oracle.net.oldSyntax")) != null && (string2.equalsIgnoreCase("ON") || string2.equalsIgnoreCase("TRUE") || string2.equalsIgnoreCase("YES"))) {
            this.newSyntax = false;
        }
    }

    private Vector<String> computeLdapList(String string) {
        String[] stringArray = pattern.split(string);
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].trim();
            if (stringArray[i2].length() == 0) continue;
            ++n2;
        }
        Vector<String> vector = new Vector<String>(n2);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (stringArray[i3].length() == 0) continue;
            vector.add(stringArray[i3]);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(Vector<String> vector) throws NetException {
        Object object;
        String string;
        boolean bl = false;
        if (vector.size() <= 1) {
            throw new NetException(124);
        }
        boolean bl2 = true;
        boolean bl3 = true;
        String string2 = this.up.getProperty("oracle.net.ldap_failover");
        if (string2 != null && (string2.equalsIgnoreCase("OFF") || string2.equalsIgnoreCase("FALSE") || string2.equalsIgnoreCase("NO"))) {
            bl2 = false;
        }
        if ((string2 = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (string2.equalsIgnoreCase("OFF") || string2.equalsIgnoreCase("FALSE") || string2.equalsIgnoreCase("NO"))) {
            bl3 = false;
        }
        if (vector.size() > 1) {
            vector = NavDescriptionList.setActiveChildren(vector, bl2, bl3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = vector.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)vector.elementAt(i2);
            int n3 = string3.lastIndexOf(47);
            if (n3 == -1) {
                throw new NetException(124);
            }
            string = string3.substring(0, n3);
            object = string3.substring(n3 + 1, string3.length());
            stringBuilder.append(string);
            if (i2 < n2 - 1) {
                stringBuilder.append(' ');
            }
            hashtable.put(string.substring(string.indexOf(47)), (String)object);
        }
        String string4 = new String(stringBuilder);
        this.up.put("java.naming.provider.url", string4);
        JndiAttrs jndiAttrs = new JndiAttrs(this.up);
        string = jndiAttrs.getLdapUrlUsed();
        this.TNSAddress = (String)hashtable.get(string.substring(string.indexOf(47)));
        object = null;
        String[] stringArray = new String[]{service_attr_name};
        try {
            object = jndiAttrs.getAttrs(this.TNSAddress, stringArray);
        }
        finally {
            jndiAttrs.close();
        }
        this.TNSAddress = (String)((Vector)object).firstElement();
        this.connection_revised = true;
    }

    public String getTNSAddress() {
        return this.TNSAddress.toUpperCase();
    }

    public ConnOption resolveAndExecute(String string, NounIntf nounIntf) throws NetException, IOException {
        return this.resolveAndExecute(string, false, nounIntf);
    }

    public ConnOption resolveAndExecute(String string, boolean bl, NounIntf nounIntf) throws NetException, IOException {
        ConnStrategy connStrategy = this.cs;
        if (string != null) {
            this.cs = new ConnStrategy(this.up);
            if (this.connection_redirected) {
                this.cs.sdu = connStrategy.sdu;
                this.cs.tdu = connStrategy.tdu;
                this.cs.retryCount = connStrategy.retryCount;
                this.cs.socketOptions = connStrategy.socketOptions;
                this.cs.reuseOpt = true;
            }
            if ((string = string.trim()).indexOf(41) == -1 || string.indexOf(40) != 0) {
                if (string.startsWith("//") || string.matches("[\\w[.+*?!/;%@a~#'$&:|^()<>\\-\\\\\\\"]]*") && !string.matches("[[\\w-]\\.]*:[\\d]*:[[\\w\\$\\#]\\.]*(?i)(:[\\w]*)?(?-i)") || string.matches("[\\[[\\w:]*\\]]") || string.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:[\\w]*)?(?-i)")) {
                    String string2 = this.up.getProperty("oracle.net.tns_admin");
                    NameResolver nameResolver = NameResolverFactory.getNameResolver(string2, this.cs.getOSUsername(), this.cs.getProgramName());
                    string = string.replaceAll("#", "\\\\#");
                    string = string.replaceAll("\\(", "\\\\(");
                    string = string.replaceAll("\\)", "\\\\)");
                    this.TNSAddress = nameResolver.resolveName(string);
                } else {
                    this.TNSAddress = this.resolveSimple(string);
                }
                this.TNSAddress = this.addConnectionProperties(this.TNSAddress);
                this.resolveAddrTree(this.TNSAddress);
            } else if (this.newSyntax) {
                string = this.addConnectionProperties(string);
                this.resolveAddrTree(string);
            } else {
                this.resolveAddr(string);
            }
        } else if (this.cs == null) {
            return null;
        }
        return this.cs.execute(bl, nounIntf);
    }

    private String addConnectionProperties(String string) {
        boolean bl;
        String string2 = string;
        if (this.up.containsKey("oracle.jdbc.targetInstanceName")) {
            string2 = this.appendInstanceName(string, this.up.getProperty("oracle.jdbc.targetInstanceName"));
        }
        if (this.up.containsKey("oracle.jdbc.targetServiceName")) {
            string2 = this.replaceServiceName(string2, this.up.getProperty("oracle.jdbc.targetServiceName"));
        }
        if (this.up.containsKey("oracle.jdbc.targetShardingKey")) {
            String string3 = null;
            if (this.up.containsKey("oracle.jdbc.targetSuperShardingKey")) {
                string3 = this.up.getProperty("oracle.jdbc.targetSuperShardingKey");
            }
            string2 = this.appendShardKeys(string2, this.up.getProperty("oracle.jdbc.targetShardingKey"), string3);
        }
        if (bl = Boolean.valueOf(System.getProperty("oracle.jdbc.readOnlyInstanceAllowed", "false")).booleanValue()) {
            string2 = this.appendReadOnly(string2);
        }
        return string2;
    }

    private String resolveSimple(String string) throws NetException {
        ConnOption connOption = new ConnOption();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = EMPTY_STRING;
        if (string.startsWith("[")) {
            n5 = string.indexOf(93);
            if (n5 == -1) {
                throw new NetException(115);
            }
            bl2 = true;
        }
        if ((n2 = string.indexOf(58, n5)) == -1 || (n3 = string.indexOf(58, n2 + 1)) == -1) {
            throw new NetException(115);
        }
        n4 = string.indexOf(58, n3 + 1);
        if (n4 != -1 && string.length() > n4 + 6) {
            string2 = string.substring(n4 + 1);
            bl3 = SERVER_MODES.contains(string2.toUpperCase());
            if (bl3) {
                connOption.sid = string.substring(n3 + 1, n4);
                n4 = string.indexOf(58, n4 + 1);
            } else {
                connOption.sid = string.substring(n3 + 1);
            }
        } else {
            connOption.sid = string.substring(n3 + 1);
        }
        if (n4 != -1) {
            throw new NetException(115);
        }
        try {
            connOption.host = bl2 ? string.substring(1, n2 - 1) : string.substring(0, n2);
            connOption.port = Integer.parseInt(string.substring(n2 + 1, n3));
            connOption.addr = String.format(ADDRESS_FORMAT, DEFAULT_CONNECT_PROTOCOL, connOption.host, connOption.port);
            connOption.conn_data.append(String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, connOption.sid), bl3 ? String.format(SERVERMODE_FORMAT, string2) : EMPTY_STRING, String.format(CID_FORMAT, this.cs.getProgramName(), this.cs.getOSUsername())), connOption.addr));
            connOption.protocol = DEFAULT_CONNECT_PROTOCOL;
            ConnectDescription connectDescription = this.cs.newConnectDescription();
            this.cs.currentDescription().addConnectOption(connOption);
            this.cs.closeDescription();
            return String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, connOption.sid), bl3 ? String.format(SERVERMODE_FORMAT, string2) : EMPTY_STRING, EMPTY_STRING), connOption.addr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(116);
        }
    }

    private void resolveAddr(String string) throws NetException {
        Object object;
        if (string.startsWith("alias=")) {
            object = string;
            string = ((String)object).substring(((String)object).indexOf("alias=") + 6, ((String)object).length());
        }
        object = new ConnOption();
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = null;
        NVPair nVPair2 = null;
        try {
            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "CID");
            nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        }
        catch (NLException nLException) {
            NetException netException = new NetException(101);
            netException.initCause(nLException);
            throw netException;
        }
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "protocol");
        if (nVPair3 == null) {
            throw new NetException(100);
        }
        ((ConnOption)object).protocol = nVPair3.getAtom();
        if (!(((ConnOption)object).protocol.equals(DEFAULT_CONNECT_PROTOCOL) || ((ConnOption)object).protocol.equals("tcp") || ((ConnOption)object).protocol.equals("SSL") || ((ConnOption)object).protocol.equals("ssl") || ((ConnOption)object).protocol.equals("ANO") || ((ConnOption)object).protocol.equals("ano"))) {
            throw new NetException(102);
        }
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Host");
        if (nVPair3 == null) {
            throw new NetException(103);
        }
        ((ConnOption)object).host = nVPair3.getAtom();
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Port");
        if (nVPair3 == null) {
            throw new NetException(104);
        }
        ((ConnOption)object).port = Integer.parseInt(nVPair3.getAtom());
        nVPair3 = nVNavigator.findNVPair(nVPair2, "sduSize");
        if (nVPair3 != null) {
            ((ConnOption)object).sdu = Integer.parseInt(nVPair3.getAtom());
        }
        if ((nVPair3 = nVNavigator.findNVPair(nVPair2, "tduSize")) != null) {
            ((ConnOption)object).tdu = Integer.parseInt(nVPair3.getAtom());
        }
        NVPair nVPair4 = null;
        try {
            nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        }
        catch (NLException nLException) {
            NetException netException = new NetException(101);
            netException.initCause(nLException);
            throw netException;
        }
        ((ConnOption)object).conn_data = nVPair4 != null ? this.insertCID(string) : new StringBuilder(string);
        ((ConnOption)object).addr = String.format(ADDRESS_FORMAT, DEFAULT_CONNECT_PROTOCOL, ((ConnOption)object).host, ((ConnOption)object).port);
        ConnectDescription connectDescription = this.cs.newConnectDescription();
        this.cs.currentDescription().addConnectOption((ConnOption)object);
        this.cs.closeDescription();
    }

    private void resolveAddrTree(String string) throws NetException {
        NavSchemaObjectFactory navSchemaObjectFactory = new NavSchemaObjectFactory();
        NavServiceAlias navServiceAlias = (NavServiceAlias)navSchemaObjectFactory.create(4);
        try {
            String string2 = string.startsWith("alias=") ? string : "alias=" + string;
            navServiceAlias.initFromString(string2);
        }
        catch (NLException nLException) {
            throw new NetException(501, nLException.getMessage());
        }
        catch (SOException sOException) {
            throw new NetException(502, sOException.getMessage());
        }
        navServiceAlias.navigate(this.cs, null);
    }

    private StringBuilder insertCID(String string) throws NetException {
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        StringBuilder stringBuilder = new StringBuilder(2048);
        NVPair nVPair = null;
        NVPair nVPair2 = null;
        NVPair nVPair3 = null;
        NVPair nVPair4 = null;
        NVPair nVPair5 = null;
        try {
            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "description");
            nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address_list");
            nVPair3 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
            nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
            nVPair5 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "source_route");
        }
        catch (NLException nLException) {
            NetException netException = new NetException(101);
            netException.initCause(nLException);
            throw netException;
        }
        NVPair nVPair6 = null;
        NVPair nVPair7 = null;
        NVPair nVPair8 = null;
        NVPair nVPair9 = null;
        if (nVPair4 == null) {
            throw new NetException(105);
        }
        nVPair6 = nVNavigator.findNVPair(nVPair4, "SID");
        nVPair7 = nVNavigator.findNVPair(nVPair4, "CID");
        nVPair8 = nVNavigator.findNVPair(nVPair4, "SERVICE_NAME");
        nVPair9 = nVNavigator.findNVPair(nVPair4, "SERVER");
        if (nVPair6 == null && nVPair8 == null) {
            throw new NetException(106);
        }
        stringBuilder.append("(DESCRIPTION=");
        if (nVPair2 != null && nVPair2.getListSize() > 0) {
            for (int i2 = 0; i2 < nVPair2.getListSize(); ++i2) {
                NVPair nVPair10 = nVPair2.getListElement(i2);
                stringBuilder.append(nVPair10.toString());
            }
        } else if (nVPair3 != null) {
            stringBuilder.append(nVPair3.toString());
        } else {
            throw new NetException(107);
        }
        stringBuilder.append(String.format(CONNECT_DATA_FORMAT, (nVPair8 != null ? nVPair8 : nVPair6).toString(), nVPair9 != null ? nVPair9.toString() : EMPTY_STRING, String.format(CID_FORMAT, this.cs.getProgramName(), this.cs.getOSUsername())));
        if (nVPair5 != null) {
            stringBuilder.append(nVPair5.toString());
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    public Properties getUp() {
        return this.up;
    }

    public Properties getSocketOptions() {
        return this.cs.socketOptions;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.cs.isConnectionSocketKeepAlive();
    }

    private String appendInstanceName(String string, String string2) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = matcher.find();
        while (bl) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group() + "(INSTANCE_NAME=" + string2 + ")"));
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String replaceServiceName(String string, String string2) {
        Pattern pattern = Pattern.compile("\\([\\s]*SERVICE_NAME[\\s]*=([^)]+)\\)", 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = matcher.find();
        while (bl) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement("(SERVICE_NAME=" + string2 + ")"));
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String appendShardKeys(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        String string4 = (string2 != null ? "(SHARDING_KEY_B64=" + string2 + ")" : EMPTY_STRING) + (string3 != null ? "(SUPER_SHARDING_KEY_B64=" + string3 + ")" : EMPTY_STRING);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = matcher.find();
        while (bl) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group() + string4));
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String appendReadOnly(String string) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = matcher.find();
        while (bl) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group() + "(READONLY_OK=true)"));
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        try {
            $$$methodRef$$$17 = AddrResolution.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$16 = AddrResolution.class.getDeclaredMethod("appendReadOnly", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$15 = AddrResolution.class.getDeclaredMethod("appendShardKeys", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$14 = AddrResolution.class.getDeclaredMethod("replaceServiceName", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = AddrResolution.class.getDeclaredMethod("appendInstanceName", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = AddrResolution.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = AddrResolution.class.getDeclaredMethod("getSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = AddrResolution.class.getDeclaredMethod("getUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = AddrResolution.class.getDeclaredMethod("insertCID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = AddrResolution.class.getDeclaredMethod("resolveAddrTree", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = AddrResolution.class.getDeclaredMethod("resolveAddr", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = AddrResolution.class.getDeclaredMethod("resolveSimple", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = AddrResolution.class.getDeclaredMethod("addConnectionProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = AddrResolution.class.getDeclaredMethod("resolveAndExecute", String.class, Boolean.TYPE, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = AddrResolution.class.getDeclaredMethod("resolveAndExecute", String.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = AddrResolution.class.getDeclaredMethod("getTNSAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = AddrResolution.class.getDeclaredMethod("processLdapFailoverLoadblance", Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = AddrResolution.class.getDeclaredMethod("computeLdapList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        SERVER_MODES = Arrays.asList("SHARED", "DEDICATED", "POOLED");
        pattern = Pattern.compile("(?=ldaps?://)");
    }
}

