/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNetworkAddressListRequest
extends BmcRequest<Void> {
    private String networkAddressListId;
    private String opcRequestId;

    public String getNetworkAddressListId() {
        return this.networkAddressListId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().networkAddressListId(this.networkAddressListId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkAddressListId=").append(String.valueOf(this.networkAddressListId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkAddressListRequest)) {
            return false;
        }
        GetNetworkAddressListRequest other = (GetNetworkAddressListRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkAddressListId, other.networkAddressListId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkAddressListId == null ? 43 : this.networkAddressListId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkAddressListRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkAddressListId = null;
        private String opcRequestId = null;

        public Builder networkAddressListId(String networkAddressListId) {
            this.networkAddressListId = networkAddressListId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkAddressListRequest o) {
            this.networkAddressListId(o.getNetworkAddressListId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkAddressListRequest build() {
            GetNetworkAddressListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNetworkAddressListRequest buildWithoutInvocationCallback() {
            GetNetworkAddressListRequest request = new GetNetworkAddressListRequest();
            request.networkAddressListId = this.networkAddressListId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

