/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListRecommendationsRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private RecommendedAction recommendedAction;
    private Integer limit;
    private String page;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RecommendedAction getRecommendedAction() {
        return this.recommendedAction;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).opcRequestId(this.opcRequestId).recommendedAction(this.recommendedAction).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",recommendedAction=").append(String.valueOf((Object)this.recommendedAction));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.recommendedAction, (Object)other.recommendedAction) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.recommendedAction == null ? 43 : this.recommendedAction.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecommendationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String opcRequestId = null;
        private RecommendedAction recommendedAction = null;
        private Integer limit = null;
        private String page = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder recommendedAction(RecommendedAction recommendedAction) {
            this.recommendedAction = recommendedAction;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecommendationsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.recommendedAction(o.getRecommendedAction());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecommendationsRequest build() {
            ListRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRecommendationsRequest buildWithoutInvocationCallback() {
            ListRecommendationsRequest request = new ListRecommendationsRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.opcRequestId = this.opcRequestId;
            request.recommendedAction = this.recommendedAction;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum RecommendedAction implements BmcEnum
    {
        Detect("DETECT"),
        Block("BLOCK");

        private final String value;
        private static Map<String, RecommendedAction> map;

        private RecommendedAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RecommendedAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RecommendedAction: " + key);
        }

        static {
            map = new HashMap<String, RecommendedAction>();
            for (RecommendedAction v : RecommendedAction.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

