/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListProtectionRulesRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private List<String> modSecurityRuleId;
    private List<Action> action;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getModSecurityRuleId() {
        return this.modSecurityRuleId;
    }

    public List<Action> getAction() {
        return this.action;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).modSecurityRuleId(this.modSecurityRuleId).action(this.action);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",modSecurityRuleId=").append(String.valueOf(this.modSecurityRuleId));
        sb.append(",action=").append(String.valueOf(this.action));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProtectionRulesRequest)) {
            return false;
        }
        ListProtectionRulesRequest other = (ListProtectionRulesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.modSecurityRuleId, other.modSecurityRuleId) && Objects.equals(this.action, other.action);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.modSecurityRuleId == null ? 43 : this.modSecurityRuleId.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProtectionRulesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private List<String> modSecurityRuleId = null;
        private List<Action> action = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder modSecurityRuleId(List<String> modSecurityRuleId) {
            this.modSecurityRuleId = modSecurityRuleId;
            return this;
        }

        public Builder modSecurityRuleId(String singularValue) {
            return this.modSecurityRuleId(Arrays.asList(singularValue));
        }

        public Builder action(List<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action singularValue) {
            return this.action(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProtectionRulesRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.modSecurityRuleId(o.getModSecurityRuleId());
            this.action(o.getAction());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProtectionRulesRequest build() {
            ListProtectionRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListProtectionRulesRequest buildWithoutInvocationCallback() {
            ListProtectionRulesRequest request = new ListProtectionRulesRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.modSecurityRuleId = this.modSecurityRuleId;
            request.action = this.action;
            return request;
        }
    }

    public static enum Action implements BmcEnum
    {
        Off("OFF"),
        Detect("DETECT"),
        Block("BLOCK");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

