/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHttpRedirectRequest
extends BmcRequest<Void> {
    private String httpRedirectId;
    private String opcRequestId;

    public String getHttpRedirectId() {
        return this.httpRedirectId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().httpRedirectId(this.httpRedirectId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",httpRedirectId=").append(String.valueOf(this.httpRedirectId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHttpRedirectRequest)) {
            return false;
        }
        GetHttpRedirectRequest other = (GetHttpRedirectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.httpRedirectId, other.httpRedirectId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.httpRedirectId == null ? 43 : this.httpRedirectId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHttpRedirectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String httpRedirectId = null;
        private String opcRequestId = null;

        public Builder httpRedirectId(String httpRedirectId) {
            this.httpRedirectId = httpRedirectId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHttpRedirectRequest o) {
            this.httpRedirectId(o.getHttpRedirectId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHttpRedirectRequest build() {
            GetHttpRedirectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHttpRedirectRequest buildWithoutInvocationCallback() {
            GetHttpRedirectRequest request = new GetHttpRedirectRequest();
            request.httpRedirectId = this.httpRedirectId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

