/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WafRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeObserved")
    private final Date timeObserved;
    @JsonProperty(value="timeRangeInSeconds")
    private final Integer timeRangeInSeconds;
    @JsonProperty(value="count")
    private final Integer count;

    @Deprecated
    @ConstructorProperties(value={"timeObserved", "timeRangeInSeconds", "count"})
    public WafRequest(Date timeObserved, Integer timeRangeInSeconds, Integer count) {
        this.timeObserved = timeObserved;
        this.timeRangeInSeconds = timeRangeInSeconds;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeObserved() {
        return this.timeObserved;
    }

    public Integer getTimeRangeInSeconds() {
        return this.timeRangeInSeconds;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WafRequest(");
        sb.append("super=").append(super.toString());
        sb.append("timeObserved=").append(String.valueOf(this.timeObserved));
        sb.append(", timeRangeInSeconds=").append(String.valueOf(this.timeRangeInSeconds));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WafRequest)) {
            return false;
        }
        WafRequest other = (WafRequest)((Object)o);
        return Objects.equals(this.timeObserved, other.timeObserved) && Objects.equals(this.timeRangeInSeconds, other.timeRangeInSeconds) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeObserved == null ? 43 : this.timeObserved.hashCode());
        result = result * 59 + (this.timeRangeInSeconds == null ? 43 : this.timeRangeInSeconds.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeObserved")
        private Date timeObserved;
        @JsonProperty(value="timeRangeInSeconds")
        private Integer timeRangeInSeconds;
        @JsonProperty(value="count")
        private Integer count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeObserved(Date timeObserved) {
            this.timeObserved = timeObserved;
            this.__explicitlySet__.add("timeObserved");
            return this;
        }

        public Builder timeRangeInSeconds(Integer timeRangeInSeconds) {
            this.timeRangeInSeconds = timeRangeInSeconds;
            this.__explicitlySet__.add("timeRangeInSeconds");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public WafRequest build() {
            WafRequest model = new WafRequest(this.timeObserved, this.timeRangeInSeconds, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WafRequest model) {
            if (model.wasPropertyExplicitlySet("timeObserved")) {
                this.timeObserved(model.getTimeObserved());
            }
            if (model.wasPropertyExplicitlySet("timeRangeInSeconds")) {
                this.timeRangeInSeconds(model.getTimeRangeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

