/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionRuleExclusion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="target")
    private final Target target;
    @JsonProperty(value="exclusions")
    private final List<String> exclusions;

    @Deprecated
    @ConstructorProperties(value={"target", "exclusions"})
    public ProtectionRuleExclusion(Target target, List<String> exclusions) {
        this.target = target;
        this.exclusions = exclusions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Target getTarget() {
        return this.target;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionRuleExclusion(");
        sb.append("super=").append(super.toString());
        sb.append("target=").append(String.valueOf((Object)this.target));
        sb.append(", exclusions=").append(String.valueOf(this.exclusions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionRuleExclusion)) {
            return false;
        }
        ProtectionRuleExclusion other = (ProtectionRuleExclusion)((Object)o);
        return Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.exclusions, other.exclusions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.exclusions == null ? 43 : this.exclusions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Target implements BmcEnum
    {
        RequestCookies("REQUEST_COOKIES"),
        RequestCookieNames("REQUEST_COOKIE_NAMES"),
        Args("ARGS"),
        ArgsNames("ARGS_NAMES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Target> map;

        private Target(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Target create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Target', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Target.class);
            map = new HashMap<String, Target>();
            for (Target v : Target.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="target")
        private Target target;
        @JsonProperty(value="exclusions")
        private List<String> exclusions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder target(Target target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder exclusions(List<String> exclusions) {
            this.exclusions = exclusions;
            this.__explicitlySet__.add("exclusions");
            return this;
        }

        public ProtectionRuleExclusion build() {
            ProtectionRuleExclusion model = new ProtectionRuleExclusion(this.target, this.exclusions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionRuleExclusion model) {
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("exclusions")) {
                this.exclusions(model.getExclusions());
            }
            return this;
        }
    }
}

