/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waas.model.CachingRuleCriteria;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CachingRuleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="cachingDuration")
    private final String cachingDuration;
    @JsonProperty(value="isClientCachingEnabled")
    private final Boolean isClientCachingEnabled;
    @JsonProperty(value="clientCachingDuration")
    private final String clientCachingDuration;
    @JsonProperty(value="criteria")
    private final List<CachingRuleCriteria> criteria;

    @Deprecated
    @ConstructorProperties(value={"key", "name", "action", "cachingDuration", "isClientCachingEnabled", "clientCachingDuration", "criteria"})
    public CachingRuleSummary(String key, String name, Action action, String cachingDuration, Boolean isClientCachingEnabled, String clientCachingDuration, List<CachingRuleCriteria> criteria) {
        this.key = key;
        this.name = name;
        this.action = action;
        this.cachingDuration = cachingDuration;
        this.isClientCachingEnabled = isClientCachingEnabled;
        this.clientCachingDuration = clientCachingDuration;
        this.criteria = criteria;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Action getAction() {
        return this.action;
    }

    public String getCachingDuration() {
        return this.cachingDuration;
    }

    public Boolean getIsClientCachingEnabled() {
        return this.isClientCachingEnabled;
    }

    public String getClientCachingDuration() {
        return this.clientCachingDuration;
    }

    public List<CachingRuleCriteria> getCriteria() {
        return this.criteria;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CachingRuleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", cachingDuration=").append(String.valueOf(this.cachingDuration));
        sb.append(", isClientCachingEnabled=").append(String.valueOf(this.isClientCachingEnabled));
        sb.append(", clientCachingDuration=").append(String.valueOf(this.clientCachingDuration));
        sb.append(", criteria=").append(String.valueOf(this.criteria));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachingRuleSummary)) {
            return false;
        }
        CachingRuleSummary other = (CachingRuleSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.cachingDuration, other.cachingDuration) && Objects.equals(this.isClientCachingEnabled, other.isClientCachingEnabled) && Objects.equals(this.clientCachingDuration, other.clientCachingDuration) && Objects.equals(this.criteria, other.criteria) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.cachingDuration == null ? 43 : this.cachingDuration.hashCode());
        result = result * 59 + (this.isClientCachingEnabled == null ? 43 : this.isClientCachingEnabled.hashCode());
        result = result * 59 + (this.clientCachingDuration == null ? 43 : this.clientCachingDuration.hashCode());
        result = result * 59 + (this.criteria == null ? 43 : this.criteria.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Cache("CACHE"),
        BypassCache("BYPASS_CACHE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="cachingDuration")
        private String cachingDuration;
        @JsonProperty(value="isClientCachingEnabled")
        private Boolean isClientCachingEnabled;
        @JsonProperty(value="clientCachingDuration")
        private String clientCachingDuration;
        @JsonProperty(value="criteria")
        private List<CachingRuleCriteria> criteria;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder cachingDuration(String cachingDuration) {
            this.cachingDuration = cachingDuration;
            this.__explicitlySet__.add("cachingDuration");
            return this;
        }

        public Builder isClientCachingEnabled(Boolean isClientCachingEnabled) {
            this.isClientCachingEnabled = isClientCachingEnabled;
            this.__explicitlySet__.add("isClientCachingEnabled");
            return this;
        }

        public Builder clientCachingDuration(String clientCachingDuration) {
            this.clientCachingDuration = clientCachingDuration;
            this.__explicitlySet__.add("clientCachingDuration");
            return this;
        }

        public Builder criteria(List<CachingRuleCriteria> criteria) {
            this.criteria = criteria;
            this.__explicitlySet__.add("criteria");
            return this;
        }

        public CachingRuleSummary build() {
            CachingRuleSummary model = new CachingRuleSummary(this.key, this.name, this.action, this.cachingDuration, this.isClientCachingEnabled, this.clientCachingDuration, this.criteria);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CachingRuleSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("cachingDuration")) {
                this.cachingDuration(model.getCachingDuration());
            }
            if (model.wasPropertyExplicitlySet("isClientCachingEnabled")) {
                this.isClientCachingEnabled(model.getIsClientCachingEnabled());
            }
            if (model.wasPropertyExplicitlySet("clientCachingDuration")) {
                this.clientCachingDuration(model.getClientCachingDuration());
            }
            if (model.wasPropertyExplicitlySet("criteria")) {
                this.criteria(model.getCriteria());
            }
            return this;
        }
    }
}

