/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waas.model.AccessRuleCriteria;
import com.oracle.bmc.waas.model.HeaderManipulationAction;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="criteria")
    private final List<AccessRuleCriteria> criteria;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="blockAction")
    private final BlockAction blockAction;
    @JsonProperty(value="blockResponseCode")
    private final Integer blockResponseCode;
    @JsonProperty(value="blockErrorPageMessage")
    private final String blockErrorPageMessage;
    @JsonProperty(value="blockErrorPageCode")
    private final String blockErrorPageCode;
    @JsonProperty(value="blockErrorPageDescription")
    private final String blockErrorPageDescription;
    @JsonProperty(value="bypassChallenges")
    private final List<BypassChallenges> bypassChallenges;
    @JsonProperty(value="redirectUrl")
    private final String redirectUrl;
    @JsonProperty(value="redirectResponseCode")
    private final RedirectResponseCode redirectResponseCode;
    @JsonProperty(value="captchaTitle")
    private final String captchaTitle;
    @JsonProperty(value="captchaHeader")
    private final String captchaHeader;
    @JsonProperty(value="captchaFooter")
    private final String captchaFooter;
    @JsonProperty(value="captchaSubmitLabel")
    private final String captchaSubmitLabel;
    @JsonProperty(value="responseHeaderManipulation")
    private final List<HeaderManipulationAction> responseHeaderManipulation;

    @Deprecated
    @ConstructorProperties(value={"name", "criteria", "action", "blockAction", "blockResponseCode", "blockErrorPageMessage", "blockErrorPageCode", "blockErrorPageDescription", "bypassChallenges", "redirectUrl", "redirectResponseCode", "captchaTitle", "captchaHeader", "captchaFooter", "captchaSubmitLabel", "responseHeaderManipulation"})
    public AccessRule(String name, List<AccessRuleCriteria> criteria, Action action, BlockAction blockAction, Integer blockResponseCode, String blockErrorPageMessage, String blockErrorPageCode, String blockErrorPageDescription, List<BypassChallenges> bypassChallenges, String redirectUrl, RedirectResponseCode redirectResponseCode, String captchaTitle, String captchaHeader, String captchaFooter, String captchaSubmitLabel, List<HeaderManipulationAction> responseHeaderManipulation) {
        this.name = name;
        this.criteria = criteria;
        this.action = action;
        this.blockAction = blockAction;
        this.blockResponseCode = blockResponseCode;
        this.blockErrorPageMessage = blockErrorPageMessage;
        this.blockErrorPageCode = blockErrorPageCode;
        this.blockErrorPageDescription = blockErrorPageDescription;
        this.bypassChallenges = bypassChallenges;
        this.redirectUrl = redirectUrl;
        this.redirectResponseCode = redirectResponseCode;
        this.captchaTitle = captchaTitle;
        this.captchaHeader = captchaHeader;
        this.captchaFooter = captchaFooter;
        this.captchaSubmitLabel = captchaSubmitLabel;
        this.responseHeaderManipulation = responseHeaderManipulation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public List<AccessRuleCriteria> getCriteria() {
        return this.criteria;
    }

    public Action getAction() {
        return this.action;
    }

    public BlockAction getBlockAction() {
        return this.blockAction;
    }

    public Integer getBlockResponseCode() {
        return this.blockResponseCode;
    }

    public String getBlockErrorPageMessage() {
        return this.blockErrorPageMessage;
    }

    public String getBlockErrorPageCode() {
        return this.blockErrorPageCode;
    }

    public String getBlockErrorPageDescription() {
        return this.blockErrorPageDescription;
    }

    public List<BypassChallenges> getBypassChallenges() {
        return this.bypassChallenges;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public RedirectResponseCode getRedirectResponseCode() {
        return this.redirectResponseCode;
    }

    public String getCaptchaTitle() {
        return this.captchaTitle;
    }

    public String getCaptchaHeader() {
        return this.captchaHeader;
    }

    public String getCaptchaFooter() {
        return this.captchaFooter;
    }

    public String getCaptchaSubmitLabel() {
        return this.captchaSubmitLabel;
    }

    public List<HeaderManipulationAction> getResponseHeaderManipulation() {
        return this.responseHeaderManipulation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessRule(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", criteria=").append(String.valueOf(this.criteria));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", blockAction=").append(String.valueOf((Object)this.blockAction));
        sb.append(", blockResponseCode=").append(String.valueOf(this.blockResponseCode));
        sb.append(", blockErrorPageMessage=").append(String.valueOf(this.blockErrorPageMessage));
        sb.append(", blockErrorPageCode=").append(String.valueOf(this.blockErrorPageCode));
        sb.append(", blockErrorPageDescription=").append(String.valueOf(this.blockErrorPageDescription));
        sb.append(", bypassChallenges=").append(String.valueOf(this.bypassChallenges));
        sb.append(", redirectUrl=").append(String.valueOf(this.redirectUrl));
        sb.append(", redirectResponseCode=").append(String.valueOf((Object)this.redirectResponseCode));
        sb.append(", captchaTitle=").append(String.valueOf(this.captchaTitle));
        sb.append(", captchaHeader=").append(String.valueOf(this.captchaHeader));
        sb.append(", captchaFooter=").append(String.valueOf(this.captchaFooter));
        sb.append(", captchaSubmitLabel=").append(String.valueOf(this.captchaSubmitLabel));
        sb.append(", responseHeaderManipulation=").append(String.valueOf(this.responseHeaderManipulation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessRule)) {
            return false;
        }
        AccessRule other = (AccessRule)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.criteria, other.criteria) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.blockAction, (Object)other.blockAction) && Objects.equals(this.blockResponseCode, other.blockResponseCode) && Objects.equals(this.blockErrorPageMessage, other.blockErrorPageMessage) && Objects.equals(this.blockErrorPageCode, other.blockErrorPageCode) && Objects.equals(this.blockErrorPageDescription, other.blockErrorPageDescription) && Objects.equals(this.bypassChallenges, other.bypassChallenges) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals((Object)this.redirectResponseCode, (Object)other.redirectResponseCode) && Objects.equals(this.captchaTitle, other.captchaTitle) && Objects.equals(this.captchaHeader, other.captchaHeader) && Objects.equals(this.captchaFooter, other.captchaFooter) && Objects.equals(this.captchaSubmitLabel, other.captchaSubmitLabel) && Objects.equals(this.responseHeaderManipulation, other.responseHeaderManipulation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.criteria == null ? 43 : this.criteria.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.blockAction == null ? 43 : this.blockAction.hashCode());
        result = result * 59 + (this.blockResponseCode == null ? 43 : this.blockResponseCode.hashCode());
        result = result * 59 + (this.blockErrorPageMessage == null ? 43 : this.blockErrorPageMessage.hashCode());
        result = result * 59 + (this.blockErrorPageCode == null ? 43 : this.blockErrorPageCode.hashCode());
        result = result * 59 + (this.blockErrorPageDescription == null ? 43 : this.blockErrorPageDescription.hashCode());
        result = result * 59 + (this.bypassChallenges == null ? 43 : this.bypassChallenges.hashCode());
        result = result * 59 + (this.redirectUrl == null ? 43 : this.redirectUrl.hashCode());
        result = result * 59 + (this.redirectResponseCode == null ? 43 : this.redirectResponseCode.hashCode());
        result = result * 59 + (this.captchaTitle == null ? 43 : this.captchaTitle.hashCode());
        result = result * 59 + (this.captchaHeader == null ? 43 : this.captchaHeader.hashCode());
        result = result * 59 + (this.captchaFooter == null ? 43 : this.captchaFooter.hashCode());
        result = result * 59 + (this.captchaSubmitLabel == null ? 43 : this.captchaSubmitLabel.hashCode());
        result = result * 59 + (this.responseHeaderManipulation == null ? 43 : this.responseHeaderManipulation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RedirectResponseCode implements BmcEnum
    {
        MovedPermanently("MOVED_PERMANENTLY"),
        Found("FOUND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RedirectResponseCode> map;

        private RedirectResponseCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RedirectResponseCode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RedirectResponseCode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RedirectResponseCode.class);
            map = new HashMap<String, RedirectResponseCode>();
            for (RedirectResponseCode v : RedirectResponseCode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BypassChallenges implements BmcEnum
    {
        JsChallenge("JS_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        Captcha("CAPTCHA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BypassChallenges> map;

        private BypassChallenges(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BypassChallenges create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BypassChallenges', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BypassChallenges.class);
            map = new HashMap<String, BypassChallenges>();
            for (BypassChallenges v : BypassChallenges.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BlockAction implements BmcEnum
    {
        SetResponseCode("SET_RESPONSE_CODE"),
        ShowErrorPage("SHOW_ERROR_PAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BlockAction> map;

        private BlockAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BlockAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BlockAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BlockAction.class);
            map = new HashMap<String, BlockAction>();
            for (BlockAction v : BlockAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        Allow("ALLOW"),
        Detect("DETECT"),
        Block("BLOCK"),
        Bypass("BYPASS"),
        Redirect("REDIRECT"),
        ShowCaptcha("SHOW_CAPTCHA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="criteria")
        private List<AccessRuleCriteria> criteria;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="blockAction")
        private BlockAction blockAction;
        @JsonProperty(value="blockResponseCode")
        private Integer blockResponseCode;
        @JsonProperty(value="blockErrorPageMessage")
        private String blockErrorPageMessage;
        @JsonProperty(value="blockErrorPageCode")
        private String blockErrorPageCode;
        @JsonProperty(value="blockErrorPageDescription")
        private String blockErrorPageDescription;
        @JsonProperty(value="bypassChallenges")
        private List<BypassChallenges> bypassChallenges;
        @JsonProperty(value="redirectUrl")
        private String redirectUrl;
        @JsonProperty(value="redirectResponseCode")
        private RedirectResponseCode redirectResponseCode;
        @JsonProperty(value="captchaTitle")
        private String captchaTitle;
        @JsonProperty(value="captchaHeader")
        private String captchaHeader;
        @JsonProperty(value="captchaFooter")
        private String captchaFooter;
        @JsonProperty(value="captchaSubmitLabel")
        private String captchaSubmitLabel;
        @JsonProperty(value="responseHeaderManipulation")
        private List<HeaderManipulationAction> responseHeaderManipulation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder criteria(List<AccessRuleCriteria> criteria) {
            this.criteria = criteria;
            this.__explicitlySet__.add("criteria");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder blockAction(BlockAction blockAction) {
            this.blockAction = blockAction;
            this.__explicitlySet__.add("blockAction");
            return this;
        }

        public Builder blockResponseCode(Integer blockResponseCode) {
            this.blockResponseCode = blockResponseCode;
            this.__explicitlySet__.add("blockResponseCode");
            return this;
        }

        public Builder blockErrorPageMessage(String blockErrorPageMessage) {
            this.blockErrorPageMessage = blockErrorPageMessage;
            this.__explicitlySet__.add("blockErrorPageMessage");
            return this;
        }

        public Builder blockErrorPageCode(String blockErrorPageCode) {
            this.blockErrorPageCode = blockErrorPageCode;
            this.__explicitlySet__.add("blockErrorPageCode");
            return this;
        }

        public Builder blockErrorPageDescription(String blockErrorPageDescription) {
            this.blockErrorPageDescription = blockErrorPageDescription;
            this.__explicitlySet__.add("blockErrorPageDescription");
            return this;
        }

        public Builder bypassChallenges(List<BypassChallenges> bypassChallenges) {
            this.bypassChallenges = bypassChallenges;
            this.__explicitlySet__.add("bypassChallenges");
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            this.__explicitlySet__.add("redirectUrl");
            return this;
        }

        public Builder redirectResponseCode(RedirectResponseCode redirectResponseCode) {
            this.redirectResponseCode = redirectResponseCode;
            this.__explicitlySet__.add("redirectResponseCode");
            return this;
        }

        public Builder captchaTitle(String captchaTitle) {
            this.captchaTitle = captchaTitle;
            this.__explicitlySet__.add("captchaTitle");
            return this;
        }

        public Builder captchaHeader(String captchaHeader) {
            this.captchaHeader = captchaHeader;
            this.__explicitlySet__.add("captchaHeader");
            return this;
        }

        public Builder captchaFooter(String captchaFooter) {
            this.captchaFooter = captchaFooter;
            this.__explicitlySet__.add("captchaFooter");
            return this;
        }

        public Builder captchaSubmitLabel(String captchaSubmitLabel) {
            this.captchaSubmitLabel = captchaSubmitLabel;
            this.__explicitlySet__.add("captchaSubmitLabel");
            return this;
        }

        public Builder responseHeaderManipulation(List<HeaderManipulationAction> responseHeaderManipulation) {
            this.responseHeaderManipulation = responseHeaderManipulation;
            this.__explicitlySet__.add("responseHeaderManipulation");
            return this;
        }

        public AccessRule build() {
            AccessRule model = new AccessRule(this.name, this.criteria, this.action, this.blockAction, this.blockResponseCode, this.blockErrorPageMessage, this.blockErrorPageCode, this.blockErrorPageDescription, this.bypassChallenges, this.redirectUrl, this.redirectResponseCode, this.captchaTitle, this.captchaHeader, this.captchaFooter, this.captchaSubmitLabel, this.responseHeaderManipulation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AccessRule model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("criteria")) {
                this.criteria(model.getCriteria());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("blockAction")) {
                this.blockAction(model.getBlockAction());
            }
            if (model.wasPropertyExplicitlySet("blockResponseCode")) {
                this.blockResponseCode(model.getBlockResponseCode());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageMessage")) {
                this.blockErrorPageMessage(model.getBlockErrorPageMessage());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageCode")) {
                this.blockErrorPageCode(model.getBlockErrorPageCode());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageDescription")) {
                this.blockErrorPageDescription(model.getBlockErrorPageDescription());
            }
            if (model.wasPropertyExplicitlySet("bypassChallenges")) {
                this.bypassChallenges(model.getBypassChallenges());
            }
            if (model.wasPropertyExplicitlySet("redirectUrl")) {
                this.redirectUrl(model.getRedirectUrl());
            }
            if (model.wasPropertyExplicitlySet("redirectResponseCode")) {
                this.redirectResponseCode(model.getRedirectResponseCode());
            }
            if (model.wasPropertyExplicitlySet("captchaTitle")) {
                this.captchaTitle(model.getCaptchaTitle());
            }
            if (model.wasPropertyExplicitlySet("captchaHeader")) {
                this.captchaHeader(model.getCaptchaHeader());
            }
            if (model.wasPropertyExplicitlySet("captchaFooter")) {
                this.captchaFooter(model.getCaptchaFooter());
            }
            if (model.wasPropertyExplicitlySet("captchaSubmitLabel")) {
                this.captchaSubmitLabel(model.getCaptchaSubmitLabel());
            }
            if (model.wasPropertyExplicitlySet("responseHeaderManipulation")) {
                this.responseHeaderManipulation(model.getResponseHeaderManipulation());
            }
            return this;
        }
    }
}

