/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waa;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waa.Waa;
import com.oracle.bmc.waa.model.WebAppAcceleration;
import com.oracle.bmc.waa.model.WebAppAccelerationPolicy;
import com.oracle.bmc.waa.requests.GetWebAppAccelerationPolicyRequest;
import com.oracle.bmc.waa.requests.GetWebAppAccelerationRequest;
import com.oracle.bmc.waa.responses.GetWebAppAccelerationPolicyResponse;
import com.oracle.bmc.waa.responses.GetWebAppAccelerationResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class WaaWaiters {
    private final ExecutorService executorService;
    private final Waa client;

    public WaaWaiters(ExecutorService executorService, Waa client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetWebAppAccelerationRequest, GetWebAppAccelerationResponse> forWebAppAcceleration(GetWebAppAccelerationRequest request, WebAppAcceleration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWebAppAcceleration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWebAppAccelerationRequest, GetWebAppAccelerationResponse> forWebAppAcceleration(GetWebAppAccelerationRequest request, WebAppAcceleration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWebAppAcceleration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWebAppAccelerationRequest, GetWebAppAccelerationResponse> forWebAppAcceleration(GetWebAppAccelerationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, WebAppAcceleration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWebAppAcceleration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWebAppAccelerationRequest, GetWebAppAccelerationResponse> forWebAppAcceleration(BmcGenericWaiter waiter, GetWebAppAccelerationRequest request, WebAppAcceleration.LifecycleState ... targetStates) {
        final HashSet<WebAppAcceleration.LifecycleState> targetStatesSet = new HashSet<WebAppAcceleration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWebAppAccelerationRequest, GetWebAppAccelerationResponse>(){

            @Override
            public GetWebAppAccelerationResponse apply(GetWebAppAccelerationRequest request) {
                return WaaWaiters.this.client.getWebAppAcceleration(request);
            }
        }, (Predicate)new Predicate<GetWebAppAccelerationResponse>(){

            @Override
            public boolean test(GetWebAppAccelerationResponse response) {
                return targetStatesSet.contains((Object)response.getWebAppAcceleration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)WebAppAcceleration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWebAppAccelerationPolicyRequest, GetWebAppAccelerationPolicyResponse> forWebAppAccelerationPolicy(GetWebAppAccelerationPolicyRequest request, WebAppAccelerationPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWebAppAccelerationPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWebAppAccelerationPolicyRequest, GetWebAppAccelerationPolicyResponse> forWebAppAccelerationPolicy(GetWebAppAccelerationPolicyRequest request, WebAppAccelerationPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWebAppAccelerationPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWebAppAccelerationPolicyRequest, GetWebAppAccelerationPolicyResponse> forWebAppAccelerationPolicy(GetWebAppAccelerationPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, WebAppAccelerationPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWebAppAccelerationPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWebAppAccelerationPolicyRequest, GetWebAppAccelerationPolicyResponse> forWebAppAccelerationPolicy(BmcGenericWaiter waiter, GetWebAppAccelerationPolicyRequest request, WebAppAccelerationPolicy.LifecycleState ... targetStates) {
        final HashSet<WebAppAccelerationPolicy.LifecycleState> targetStatesSet = new HashSet<WebAppAccelerationPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWebAppAccelerationPolicyRequest, GetWebAppAccelerationPolicyResponse>(){

            @Override
            public GetWebAppAccelerationPolicyResponse apply(GetWebAppAccelerationPolicyRequest request) {
                return WaaWaiters.this.client.getWebAppAccelerationPolicy(request);
            }
        }, (Predicate)new Predicate<GetWebAppAccelerationPolicyResponse>(){

            @Override
            public boolean test(GetWebAppAccelerationPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getWebAppAccelerationPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)WebAppAccelerationPolicy.LifecycleState.Deleted)), (Object)request);
    }
}

