/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waa;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waa.Waa;
import com.oracle.bmc.waa.WaaAsyncClient;
import com.oracle.bmc.waa.WaaPaginators;
import com.oracle.bmc.waa.WaaWaiters;
import com.oracle.bmc.waa.model.WebAppAcceleration;
import com.oracle.bmc.waa.model.WebAppAccelerationCollection;
import com.oracle.bmc.waa.model.WebAppAccelerationPolicy;
import com.oracle.bmc.waa.model.WebAppAccelerationPolicyCollection;
import com.oracle.bmc.waa.requests.ChangeWebAppAccelerationCompartmentRequest;
import com.oracle.bmc.waa.requests.ChangeWebAppAccelerationPolicyCompartmentRequest;
import com.oracle.bmc.waa.requests.CreateWebAppAccelerationPolicyRequest;
import com.oracle.bmc.waa.requests.CreateWebAppAccelerationRequest;
import com.oracle.bmc.waa.requests.DeleteWebAppAccelerationPolicyRequest;
import com.oracle.bmc.waa.requests.DeleteWebAppAccelerationRequest;
import com.oracle.bmc.waa.requests.GetWebAppAccelerationPolicyRequest;
import com.oracle.bmc.waa.requests.GetWebAppAccelerationRequest;
import com.oracle.bmc.waa.requests.ListWebAppAccelerationPoliciesRequest;
import com.oracle.bmc.waa.requests.ListWebAppAccelerationsRequest;
import com.oracle.bmc.waa.requests.PurgeWebAppAccelerationCacheRequest;
import com.oracle.bmc.waa.requests.UpdateWebAppAccelerationPolicyRequest;
import com.oracle.bmc.waa.requests.UpdateWebAppAccelerationRequest;
import com.oracle.bmc.waa.responses.ChangeWebAppAccelerationCompartmentResponse;
import com.oracle.bmc.waa.responses.ChangeWebAppAccelerationPolicyCompartmentResponse;
import com.oracle.bmc.waa.responses.CreateWebAppAccelerationPolicyResponse;
import com.oracle.bmc.waa.responses.CreateWebAppAccelerationResponse;
import com.oracle.bmc.waa.responses.DeleteWebAppAccelerationPolicyResponse;
import com.oracle.bmc.waa.responses.DeleteWebAppAccelerationResponse;
import com.oracle.bmc.waa.responses.GetWebAppAccelerationPolicyResponse;
import com.oracle.bmc.waa.responses.GetWebAppAccelerationResponse;
import com.oracle.bmc.waa.responses.ListWebAppAccelerationPoliciesResponse;
import com.oracle.bmc.waa.responses.ListWebAppAccelerationsResponse;
import com.oracle.bmc.waa.responses.PurgeWebAppAccelerationCacheResponse;
import com.oracle.bmc.waa.responses.UpdateWebAppAccelerationPolicyResponse;
import com.oracle.bmc.waa.responses.UpdateWebAppAccelerationResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaaClient
extends BaseSyncClient
implements Waa {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAA").serviceEndpointPrefix("").serviceEndpointTemplate("https://waa.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(WaaAsyncClient.class);
    private final WaaWaiters waiters;
    private final WaaPaginators paginators;

    private WaaClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Waa-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new WaaWaiters(executorService, this);
        this.paginators = new WaaPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeWebAppAccelerationCompartmentResponse changeWebAppAccelerationCompartment(ChangeWebAppAccelerationCompartmentRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationId(), (String)"webAppAccelerationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppAccelerationCompartmentDetails(), "changeWebAppAccelerationCompartmentDetails is required");
        return (ChangeWebAppAccelerationCompartmentResponse)this.clientCall(request, ChangeWebAppAccelerationCompartmentResponse::builder).logger(LOG, "changeWebAppAccelerationCompartment").serviceDetails("Waa", "ChangeWebAppAccelerationCompartment", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/ChangeWebAppAccelerationCompartment").method(Method.POST).requestBuilder(ChangeWebAppAccelerationCompartmentRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendPathParam(request.getWebAppAccelerationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppAccelerationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppAccelerationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeWebAppAccelerationPolicyCompartmentResponse changeWebAppAccelerationPolicyCompartment(ChangeWebAppAccelerationPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationPolicyId(), (String)"webAppAccelerationPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppAccelerationPolicyCompartmentDetails(), "changeWebAppAccelerationPolicyCompartmentDetails is required");
        return (ChangeWebAppAccelerationPolicyCompartmentResponse)this.clientCall(request, ChangeWebAppAccelerationPolicyCompartmentResponse::builder).logger(LOG, "changeWebAppAccelerationPolicyCompartment").serviceDetails("Waa", "ChangeWebAppAccelerationPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/ChangeWebAppAccelerationPolicyCompartment").method(Method.POST).requestBuilder(ChangeWebAppAccelerationPolicyCompartmentRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").appendPathParam(request.getWebAppAccelerationPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppAccelerationPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppAccelerationPolicyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateWebAppAccelerationResponse createWebAppAcceleration(CreateWebAppAccelerationRequest request) {
        Objects.requireNonNull(request.getCreateWebAppAccelerationDetails(), "createWebAppAccelerationDetails is required");
        return (CreateWebAppAccelerationResponse)this.clientCall(request, CreateWebAppAccelerationResponse::builder).logger(LOG, "createWebAppAcceleration").serviceDetails("Waa", "CreateWebAppAcceleration", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/CreateWebAppAcceleration").method(Method.POST).requestBuilder(CreateWebAppAccelerationRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WebAppAcceleration.class, CreateWebAppAccelerationResponse.Builder::webAppAcceleration).handleResponseHeaderString("etag", CreateWebAppAccelerationResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppAccelerationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppAccelerationResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppAccelerationResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppAccelerationResponse.Builder::contentLocation).callSync();
    }

    @Override
    public CreateWebAppAccelerationPolicyResponse createWebAppAccelerationPolicy(CreateWebAppAccelerationPolicyRequest request) {
        Objects.requireNonNull(request.getCreateWebAppAccelerationPolicyDetails(), "createWebAppAccelerationPolicyDetails is required");
        return (CreateWebAppAccelerationPolicyResponse)this.clientCall(request, CreateWebAppAccelerationPolicyResponse::builder).logger(LOG, "createWebAppAccelerationPolicy").serviceDetails("Waa", "CreateWebAppAccelerationPolicy", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/CreateWebAppAccelerationPolicy").method(Method.POST).requestBuilder(CreateWebAppAccelerationPolicyRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WebAppAccelerationPolicy.class, CreateWebAppAccelerationPolicyResponse.Builder::webAppAccelerationPolicy).handleResponseHeaderString("etag", CreateWebAppAccelerationPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppAccelerationPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppAccelerationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppAccelerationPolicyResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppAccelerationPolicyResponse.Builder::contentLocation).callSync();
    }

    @Override
    public DeleteWebAppAccelerationResponse deleteWebAppAcceleration(DeleteWebAppAccelerationRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationId(), (String)"webAppAccelerationId must not be blank", (Object[])new Object[0]);
        return (DeleteWebAppAccelerationResponse)this.clientCall(request, DeleteWebAppAccelerationResponse::builder).logger(LOG, "deleteWebAppAcceleration").serviceDetails("Waa", "DeleteWebAppAcceleration", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/DeleteWebAppAcceleration").method(Method.DELETE).requestBuilder(DeleteWebAppAccelerationRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendPathParam(request.getWebAppAccelerationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWebAppAccelerationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppAccelerationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWebAppAccelerationPolicyResponse deleteWebAppAccelerationPolicy(DeleteWebAppAccelerationPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationPolicyId(), (String)"webAppAccelerationPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteWebAppAccelerationPolicyResponse)this.clientCall(request, DeleteWebAppAccelerationPolicyResponse::builder).logger(LOG, "deleteWebAppAccelerationPolicy").serviceDetails("Waa", "DeleteWebAppAccelerationPolicy", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/DeleteWebAppAccelerationPolicy").method(Method.DELETE).requestBuilder(DeleteWebAppAccelerationPolicyRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").appendPathParam(request.getWebAppAccelerationPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWebAppAccelerationPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppAccelerationPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWebAppAccelerationResponse getWebAppAcceleration(GetWebAppAccelerationRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationId(), (String)"webAppAccelerationId must not be blank", (Object[])new Object[0]);
        return (GetWebAppAccelerationResponse)this.clientCall(request, GetWebAppAccelerationResponse::builder).logger(LOG, "getWebAppAcceleration").serviceDetails("Waa", "GetWebAppAcceleration", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/GetWebAppAcceleration").method(Method.GET).requestBuilder(GetWebAppAccelerationRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendPathParam(request.getWebAppAccelerationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppAcceleration.class, GetWebAppAccelerationResponse.Builder::webAppAcceleration).handleResponseHeaderString("etag", GetWebAppAccelerationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppAccelerationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWebAppAccelerationPolicyResponse getWebAppAccelerationPolicy(GetWebAppAccelerationPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationPolicyId(), (String)"webAppAccelerationPolicyId must not be blank", (Object[])new Object[0]);
        return (GetWebAppAccelerationPolicyResponse)this.clientCall(request, GetWebAppAccelerationPolicyResponse::builder).logger(LOG, "getWebAppAccelerationPolicy").serviceDetails("Waa", "GetWebAppAccelerationPolicy", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/GetWebAppAccelerationPolicy").method(Method.GET).requestBuilder(GetWebAppAccelerationPolicyRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").appendPathParam(request.getWebAppAccelerationPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppAccelerationPolicy.class, GetWebAppAccelerationPolicyResponse.Builder::webAppAccelerationPolicy).handleResponseHeaderString("etag", GetWebAppAccelerationPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppAccelerationPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWebAppAccelerationPoliciesResponse listWebAppAccelerationPolicies(ListWebAppAccelerationPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWebAppAccelerationPoliciesResponse)this.clientCall(request, ListWebAppAccelerationPoliciesResponse::builder).logger(LOG, "listWebAppAccelerationPolicies").serviceDetails("Waa", "ListWebAppAccelerationPolicies", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/ListWebAppAccelerationPolicies").method(Method.GET).requestBuilder(ListWebAppAccelerationPoliciesRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppAccelerationPolicyCollection.class, ListWebAppAccelerationPoliciesResponse.Builder::webAppAccelerationPolicyCollection).handleResponseHeaderString("opc-request-id", ListWebAppAccelerationPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppAccelerationPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWebAppAccelerationsResponse listWebAppAccelerations(ListWebAppAccelerationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWebAppAccelerationsResponse)this.clientCall(request, ListWebAppAccelerationsResponse::builder).logger(LOG, "listWebAppAccelerations").serviceDetails("Waa", "ListWebAppAccelerations", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/ListWebAppAccelerations").method(Method.GET).requestBuilder(ListWebAppAccelerationsRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("webAppAccelerationPolicyId", (Object)request.getWebAppAccelerationPolicyId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppAccelerationCollection.class, ListWebAppAccelerationsResponse.Builder::webAppAccelerationCollection).handleResponseHeaderString("opc-request-id", ListWebAppAccelerationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppAccelerationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PurgeWebAppAccelerationCacheResponse purgeWebAppAccelerationCache(PurgeWebAppAccelerationCacheRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationId(), (String)"webAppAccelerationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPurgeWebAppAccelerationCacheDetails(), "purgeWebAppAccelerationCacheDetails is required");
        return (PurgeWebAppAccelerationCacheResponse)this.clientCall(request, PurgeWebAppAccelerationCacheResponse::builder).logger(LOG, "purgeWebAppAccelerationCache").serviceDetails("Waa", "PurgeWebAppAccelerationCache", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/PurgeWebAppAccelerationCache").method(Method.POST).requestBuilder(PurgeWebAppAccelerationCacheRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendPathParam(request.getWebAppAccelerationId()).appendPathParam("actions").appendPathParam("purgeCache").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", PurgeWebAppAccelerationCacheResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PurgeWebAppAccelerationCacheResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateWebAppAccelerationResponse updateWebAppAcceleration(UpdateWebAppAccelerationRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationId(), (String)"webAppAccelerationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppAccelerationDetails(), "updateWebAppAccelerationDetails is required");
        return (UpdateWebAppAccelerationResponse)this.clientCall(request, UpdateWebAppAccelerationResponse::builder).logger(LOG, "updateWebAppAcceleration").serviceDetails("Waa", "UpdateWebAppAcceleration", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAcceleration/UpdateWebAppAcceleration").method(Method.PUT).requestBuilder(UpdateWebAppAccelerationRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerations").appendPathParam(request.getWebAppAccelerationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppAccelerationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppAccelerationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateWebAppAccelerationPolicyResponse updateWebAppAccelerationPolicy(UpdateWebAppAccelerationPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppAccelerationPolicyId(), (String)"webAppAccelerationPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppAccelerationPolicyDetails(), "updateWebAppAccelerationPolicyDetails is required");
        return (UpdateWebAppAccelerationPolicyResponse)this.clientCall(request, UpdateWebAppAccelerationPolicyResponse::builder).logger(LOG, "updateWebAppAccelerationPolicy").serviceDetails("Waa", "UpdateWebAppAccelerationPolicy", "https://docs.oracle.com/iaas/api/#/en/waa/20211230/WebAppAccelerationPolicy/UpdateWebAppAccelerationPolicy").method(Method.PUT).requestBuilder(UpdateWebAppAccelerationPolicyRequest::builder).basePath("/20211230").appendPathParam("webAppAccelerationPolicies").appendPathParam(request.getWebAppAccelerationPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppAccelerationPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppAccelerationPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public WaaWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public WaaPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public WaaClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)WaaClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(WaaClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaaClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WaaClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WaaClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public WaaClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new WaaClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

