/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.ImpactedHostSortBy;
import com.oracle.bmc.vulnerabilityscanning.model.SortOrder;
import java.util.Objects;

public class ListHostVulnerabilityImpactedHostsRequest
extends BmcRequest<Void> {
    private String hostVulnerabilityId;
    private SortOrder sortOrder;
    private ImpactedHostSortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getHostVulnerabilityId() {
        return this.hostVulnerabilityId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ImpactedHostSortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().hostVulnerabilityId(this.hostVulnerabilityId).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",hostVulnerabilityId=").append(String.valueOf(this.hostVulnerabilityId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostVulnerabilityImpactedHostsRequest)) {
            return false;
        }
        ListHostVulnerabilityImpactedHostsRequest other = (ListHostVulnerabilityImpactedHostsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.hostVulnerabilityId, other.hostVulnerabilityId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostVulnerabilityId == null ? 43 : this.hostVulnerabilityId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListHostVulnerabilityImpactedHostsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String hostVulnerabilityId = null;
        private SortOrder sortOrder = null;
        private ImpactedHostSortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder hostVulnerabilityId(String hostVulnerabilityId) {
            this.hostVulnerabilityId = hostVulnerabilityId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(ImpactedHostSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListHostVulnerabilityImpactedHostsRequest o) {
            this.hostVulnerabilityId(o.getHostVulnerabilityId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListHostVulnerabilityImpactedHostsRequest build() {
            ListHostVulnerabilityImpactedHostsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListHostVulnerabilityImpactedHostsRequest buildWithoutInvocationCallback() {
            ListHostVulnerabilityImpactedHostsRequest request = new ListHostVulnerabilityImpactedHostsRequest();
            request.hostVulnerabilityId = this.hostVulnerabilityId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

