/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySortBy;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.SortOrder;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType;
import java.util.Objects;

public class ListHostVulnerabilitiesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private ScanResultProblemSeverity severity;
    private String name;
    private String cveReference;
    private VulnerabilityType vulnerabilityType;
    private SortOrder sortOrder;
    private HostVulnerabilitySortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public ScanResultProblemSeverity getSeverity() {
        return this.severity;
    }

    public String getName() {
        return this.name;
    }

    public String getCveReference() {
        return this.cveReference;
    }

    public VulnerabilityType getVulnerabilityType() {
        return this.vulnerabilityType;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public HostVulnerabilitySortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).severity(this.severity).name(this.name).cveReference(this.cveReference).vulnerabilityType(this.vulnerabilityType).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",severity=").append(String.valueOf((Object)this.severity));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",cveReference=").append(String.valueOf(this.cveReference));
        sb.append(",vulnerabilityType=").append(String.valueOf((Object)this.vulnerabilityType));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostVulnerabilitiesRequest)) {
            return false;
        }
        ListHostVulnerabilitiesRequest other = (ListHostVulnerabilitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.name, other.name) && Objects.equals(this.cveReference, other.cveReference) && Objects.equals((Object)this.vulnerabilityType, (Object)other.vulnerabilityType) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = result * 59 + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListHostVulnerabilitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private ScanResultProblemSeverity severity = null;
        private String name = null;
        private String cveReference = null;
        private VulnerabilityType vulnerabilityType = null;
        private SortOrder sortOrder = null;
        private HostVulnerabilitySortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            return this;
        }

        public Builder vulnerabilityType(VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(HostVulnerabilitySortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListHostVulnerabilitiesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.severity(o.getSeverity());
            this.name(o.getName());
            this.cveReference(o.getCveReference());
            this.vulnerabilityType(o.getVulnerabilityType());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListHostVulnerabilitiesRequest build() {
            ListHostVulnerabilitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListHostVulnerabilitiesRequest buildWithoutInvocationCallback() {
            ListHostVulnerabilitiesRequest request = new ListHostVulnerabilitiesRequest();
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.severity = this.severity;
            request.name = this.name;
            request.cveReference = this.cveReference;
            request.vulnerabilityType = this.vulnerabilityType;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

