/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanAgentConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.VendorType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="vendor")
@JsonFilter(value="explicitlySetFilter")
public final class HostScanAgentConfigurationQualys
extends HostScanAgentConfiguration {
    @JsonProperty(value="vaultSecretId")
    private final String vaultSecretId;
    @JsonProperty(value="shouldUnInstall")
    private final Boolean shouldUnInstall;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostScanAgentConfigurationQualys(VendorType vendorType, String vaultSecretId, Boolean shouldUnInstall) {
        super(vendorType);
        this.vaultSecretId = vaultSecretId;
        this.shouldUnInstall = shouldUnInstall;
    }

    public String getVaultSecretId() {
        return this.vaultSecretId;
    }

    public Boolean getShouldUnInstall() {
        return this.shouldUnInstall;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostScanAgentConfigurationQualys(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vaultSecretId=").append(String.valueOf(this.vaultSecretId));
        sb.append(", shouldUnInstall=").append(String.valueOf(this.shouldUnInstall));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostScanAgentConfigurationQualys)) {
            return false;
        }
        HostScanAgentConfigurationQualys other = (HostScanAgentConfigurationQualys)((Object)o);
        return Objects.equals(this.vaultSecretId, other.vaultSecretId) && Objects.equals(this.shouldUnInstall, other.shouldUnInstall) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultSecretId == null ? 43 : this.vaultSecretId.hashCode());
        result = result * 59 + (this.shouldUnInstall == null ? 43 : this.shouldUnInstall.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vendorType")
        private VendorType vendorType;
        @JsonProperty(value="vaultSecretId")
        private String vaultSecretId;
        @JsonProperty(value="shouldUnInstall")
        private Boolean shouldUnInstall;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vendorType(VendorType vendorType) {
            this.vendorType = vendorType;
            this.__explicitlySet__.add("vendorType");
            return this;
        }

        public Builder vaultSecretId(String vaultSecretId) {
            this.vaultSecretId = vaultSecretId;
            this.__explicitlySet__.add("vaultSecretId");
            return this;
        }

        public Builder shouldUnInstall(Boolean shouldUnInstall) {
            this.shouldUnInstall = shouldUnInstall;
            this.__explicitlySet__.add("shouldUnInstall");
            return this;
        }

        public HostScanAgentConfigurationQualys build() {
            HostScanAgentConfigurationQualys model = new HostScanAgentConfigurationQualys(this.vendorType, this.vaultSecretId, this.shouldUnInstall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostScanAgentConfigurationQualys model) {
            if (model.wasPropertyExplicitlySet("vendorType")) {
                this.vendorType(model.getVendorType());
            }
            if (model.wasPropertyExplicitlySet("vaultSecretId")) {
                this.vaultSecretId(model.getVaultSecretId());
            }
            if (model.wasPropertyExplicitlySet("shouldUnInstall")) {
                this.shouldUnInstall(model.getShouldUnInstall());
            }
            return this;
        }
    }
}

