/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CveDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cveReference")
    private final String cveReference;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="relatedCveReference")
    private final String relatedCveReference;
    @JsonProperty(value="cvss3")
    private final String cvss3;
    @JsonProperty(value="timePublished")
    private final Date timePublished;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="threat")
    private final String threat;
    @JsonProperty(value="impact")
    private final String impact;
    @JsonProperty(value="solution")
    private final String solution;
    @JsonProperty(value="patchable")
    private final String patchable;
    @JsonProperty(value="exploitable")
    private final String exploitable;
    @JsonProperty(value="referenceUrl")
    private final String referenceUrl;

    @Deprecated
    @ConstructorProperties(value={"cveReference", "title", "description", "relatedCveReference", "cvss3", "timePublished", "timeUpdated", "threat", "impact", "solution", "patchable", "exploitable", "referenceUrl"})
    public CveDetails(String cveReference, String title, String description, String relatedCveReference, String cvss3, Date timePublished, Date timeUpdated, String threat, String impact, String solution, String patchable, String exploitable, String referenceUrl) {
        this.cveReference = cveReference;
        this.title = title;
        this.description = description;
        this.relatedCveReference = relatedCveReference;
        this.cvss3 = cvss3;
        this.timePublished = timePublished;
        this.timeUpdated = timeUpdated;
        this.threat = threat;
        this.impact = impact;
        this.solution = solution;
        this.patchable = patchable;
        this.exploitable = exploitable;
        this.referenceUrl = referenceUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCveReference() {
        return this.cveReference;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRelatedCveReference() {
        return this.relatedCveReference;
    }

    public String getCvss3() {
        return this.cvss3;
    }

    public Date getTimePublished() {
        return this.timePublished;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getThreat() {
        return this.threat;
    }

    public String getImpact() {
        return this.impact;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getPatchable() {
        return this.patchable;
    }

    public String getExploitable() {
        return this.exploitable;
    }

    public String getReferenceUrl() {
        return this.referenceUrl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CveDetails(");
        sb.append("super=").append(super.toString());
        sb.append("cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", relatedCveReference=").append(String.valueOf(this.relatedCveReference));
        sb.append(", cvss3=").append(String.valueOf(this.cvss3));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", threat=").append(String.valueOf(this.threat));
        sb.append(", impact=").append(String.valueOf(this.impact));
        sb.append(", solution=").append(String.valueOf(this.solution));
        sb.append(", patchable=").append(String.valueOf(this.patchable));
        sb.append(", exploitable=").append(String.valueOf(this.exploitable));
        sb.append(", referenceUrl=").append(String.valueOf(this.referenceUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CveDetails)) {
            return false;
        }
        CveDetails other = (CveDetails)((Object)o);
        return Objects.equals(this.cveReference, other.cveReference) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.relatedCveReference, other.relatedCveReference) && Objects.equals(this.cvss3, other.cvss3) && Objects.equals(this.timePublished, other.timePublished) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.threat, other.threat) && Objects.equals(this.impact, other.impact) && Objects.equals(this.solution, other.solution) && Objects.equals(this.patchable, other.patchable) && Objects.equals(this.exploitable, other.exploitable) && Objects.equals(this.referenceUrl, other.referenceUrl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.relatedCveReference == null ? 43 : this.relatedCveReference.hashCode());
        result = result * 59 + (this.cvss3 == null ? 43 : this.cvss3.hashCode());
        result = result * 59 + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.threat == null ? 43 : this.threat.hashCode());
        result = result * 59 + (this.impact == null ? 43 : this.impact.hashCode());
        result = result * 59 + (this.solution == null ? 43 : this.solution.hashCode());
        result = result * 59 + (this.patchable == null ? 43 : this.patchable.hashCode());
        result = result * 59 + (this.exploitable == null ? 43 : this.exploitable.hashCode());
        result = result * 59 + (this.referenceUrl == null ? 43 : this.referenceUrl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cveReference")
        private String cveReference;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="relatedCveReference")
        private String relatedCveReference;
        @JsonProperty(value="cvss3")
        private String cvss3;
        @JsonProperty(value="timePublished")
        private Date timePublished;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="threat")
        private String threat;
        @JsonProperty(value="impact")
        private String impact;
        @JsonProperty(value="solution")
        private String solution;
        @JsonProperty(value="patchable")
        private String patchable;
        @JsonProperty(value="exploitable")
        private String exploitable;
        @JsonProperty(value="referenceUrl")
        private String referenceUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder relatedCveReference(String relatedCveReference) {
            this.relatedCveReference = relatedCveReference;
            this.__explicitlySet__.add("relatedCveReference");
            return this;
        }

        public Builder cvss3(String cvss3) {
            this.cvss3 = cvss3;
            this.__explicitlySet__.add("cvss3");
            return this;
        }

        public Builder timePublished(Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder threat(String threat) {
            this.threat = threat;
            this.__explicitlySet__.add("threat");
            return this;
        }

        public Builder impact(String impact) {
            this.impact = impact;
            this.__explicitlySet__.add("impact");
            return this;
        }

        public Builder solution(String solution) {
            this.solution = solution;
            this.__explicitlySet__.add("solution");
            return this;
        }

        public Builder patchable(String patchable) {
            this.patchable = patchable;
            this.__explicitlySet__.add("patchable");
            return this;
        }

        public Builder exploitable(String exploitable) {
            this.exploitable = exploitable;
            this.__explicitlySet__.add("exploitable");
            return this;
        }

        public Builder referenceUrl(String referenceUrl) {
            this.referenceUrl = referenceUrl;
            this.__explicitlySet__.add("referenceUrl");
            return this;
        }

        public CveDetails build() {
            CveDetails model = new CveDetails(this.cveReference, this.title, this.description, this.relatedCveReference, this.cvss3, this.timePublished, this.timeUpdated, this.threat, this.impact, this.solution, this.patchable, this.exploitable, this.referenceUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CveDetails model) {
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("relatedCveReference")) {
                this.relatedCveReference(model.getRelatedCveReference());
            }
            if (model.wasPropertyExplicitlySet("cvss3")) {
                this.cvss3(model.getCvss3());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("threat")) {
                this.threat(model.getThreat());
            }
            if (model.wasPropertyExplicitlySet("impact")) {
                this.impact(model.getImpact());
            }
            if (model.wasPropertyExplicitlySet("solution")) {
                this.solution(model.getSolution());
            }
            if (model.wasPropertyExplicitlySet("patchable")) {
                this.patchable(model.getPatchable());
            }
            if (model.wasPropertyExplicitlySet("exploitable")) {
                this.exploitable(model.getExploitable());
            }
            if (model.wasPropertyExplicitlySet("referenceUrl")) {
                this.referenceUrl(model.getReferenceUrl());
            }
            return this;
        }
    }
}

