/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.visualbuilder.VbInstance;
import com.oracle.bmc.visualbuilder.model.VbInstance;
import com.oracle.bmc.visualbuilder.requests.GetVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.GetWorkRequestRequest;
import com.oracle.bmc.visualbuilder.responses.GetVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VbInstanceWaiters {
    private final ExecutorService executorService;
    private final VbInstance client;

    public VbInstanceWaiters(ExecutorService executorService, VbInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetVbInstanceRequest, GetVbInstanceResponse> forVbInstance(GetVbInstanceRequest request, VbInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVbInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVbInstanceRequest, GetVbInstanceResponse> forVbInstance(GetVbInstanceRequest request, VbInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVbInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVbInstanceRequest, GetVbInstanceResponse> forVbInstance(GetVbInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VbInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVbInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVbInstanceRequest, GetVbInstanceResponse> forVbInstance(BmcGenericWaiter waiter, GetVbInstanceRequest request, VbInstance.LifecycleState ... targetStates) {
        final HashSet<VbInstance.LifecycleState> targetStatesSet = new HashSet<VbInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVbInstanceRequest, GetVbInstanceResponse>(){

            @Override
            public GetVbInstanceResponse apply(GetVbInstanceRequest request) {
                return VbInstanceWaiters.this.client.getVbInstance(request);
            }
        }, (Predicate)new Predicate<GetVbInstanceResponse>(){

            @Override
            public boolean test(GetVbInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getVbInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VbInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return VbInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

