/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListRewardsRequest
extends BmcRequest<Void> {
    private String tenancyId;
    private String subscriptionId;
    private String opcRequestId;

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tenancyId(this.tenancyId).subscriptionId(this.subscriptionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRewardsRequest)) {
            return false;
        }
        ListRewardsRequest other = (ListRewardsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRewardsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tenancyId = null;
        private String subscriptionId = null;
        private String opcRequestId = null;

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRewardsRequest o) {
            this.tenancyId(o.getTenancyId());
            this.subscriptionId(o.getSubscriptionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRewardsRequest build() {
            ListRewardsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRewardsRequest buildWithoutInvocationCallback() {
            ListRewardsRequest request = new ListRewardsRequest();
            request.tenancyId = this.tenancyId;
            request.subscriptionId = this.subscriptionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

