/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteRedeemableUserRequest
extends BmcRequest<Void> {
    private String emailId;
    private String tenancyId;
    private String subscriptionId;
    private String opcRequestId;
    private String ifMatch;

    public String getEmailId() {
        return this.emailId;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().emailId(this.emailId).tenancyId(this.tenancyId).subscriptionId(this.subscriptionId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",emailId=").append(String.valueOf(this.emailId));
        sb.append(",tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteRedeemableUserRequest)) {
            return false;
        }
        DeleteRedeemableUserRequest other = (DeleteRedeemableUserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.emailId, other.emailId) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.emailId == null ? 43 : this.emailId.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteRedeemableUserRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String emailId = null;
        private String tenancyId = null;
        private String subscriptionId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRedeemableUserRequest o) {
            this.emailId(o.getEmailId());
            this.tenancyId(o.getTenancyId());
            this.subscriptionId(o.getSubscriptionId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRedeemableUserRequest build() {
            DeleteRedeemableUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteRedeemableUserRequest buildWithoutInvocationCallback() {
            DeleteRedeemableUserRequest request = new DeleteRedeemableUserRequest();
            request.emailId = this.emailId;
            request.tenancyId = this.tenancyId;
            request.subscriptionId = this.subscriptionId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

