/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RewardDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="currency")
    private final String currency;
    @JsonProperty(value="rewardsRate")
    private final Double rewardsRate;
    @JsonProperty(value="totalRewardsAvailable")
    private final Float totalRewardsAvailable;
    @JsonProperty(value="redemptionCode")
    private final String redemptionCode;

    @Deprecated
    @ConstructorProperties(value={"tenancyId", "subscriptionId", "currency", "rewardsRate", "totalRewardsAvailable", "redemptionCode"})
    public RewardDetails(String tenancyId, String subscriptionId, String currency, Double rewardsRate, Float totalRewardsAvailable, String redemptionCode) {
        this.tenancyId = tenancyId;
        this.subscriptionId = subscriptionId;
        this.currency = currency;
        this.rewardsRate = rewardsRate;
        this.totalRewardsAvailable = totalRewardsAvailable;
        this.redemptionCode = redemptionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Double getRewardsRate() {
        return this.rewardsRate;
    }

    public Float getTotalRewardsAvailable() {
        return this.totalRewardsAvailable;
    }

    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RewardDetails(");
        sb.append("super=").append(super.toString());
        sb.append("tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", currency=").append(String.valueOf(this.currency));
        sb.append(", rewardsRate=").append(String.valueOf(this.rewardsRate));
        sb.append(", totalRewardsAvailable=").append(String.valueOf(this.totalRewardsAvailable));
        sb.append(", redemptionCode=").append(String.valueOf(this.redemptionCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RewardDetails)) {
            return false;
        }
        RewardDetails other = (RewardDetails)((Object)o);
        return Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.currency, other.currency) && Objects.equals(this.rewardsRate, other.rewardsRate) && Objects.equals(this.totalRewardsAvailable, other.totalRewardsAvailable) && Objects.equals(this.redemptionCode, other.redemptionCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.rewardsRate == null ? 43 : this.rewardsRate.hashCode());
        result = result * 59 + (this.totalRewardsAvailable == null ? 43 : this.totalRewardsAvailable.hashCode());
        result = result * 59 + (this.redemptionCode == null ? 43 : this.redemptionCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="currency")
        private String currency;
        @JsonProperty(value="rewardsRate")
        private Double rewardsRate;
        @JsonProperty(value="totalRewardsAvailable")
        private Float totalRewardsAvailable;
        @JsonProperty(value="redemptionCode")
        private String redemptionCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder rewardsRate(Double rewardsRate) {
            this.rewardsRate = rewardsRate;
            this.__explicitlySet__.add("rewardsRate");
            return this;
        }

        public Builder totalRewardsAvailable(Float totalRewardsAvailable) {
            this.totalRewardsAvailable = totalRewardsAvailable;
            this.__explicitlySet__.add("totalRewardsAvailable");
            return this;
        }

        public Builder redemptionCode(String redemptionCode) {
            this.redemptionCode = redemptionCode;
            this.__explicitlySet__.add("redemptionCode");
            return this;
        }

        public RewardDetails build() {
            RewardDetails model = new RewardDetails(this.tenancyId, this.subscriptionId, this.currency, this.rewardsRate, this.totalRewardsAvailable, this.redemptionCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RewardDetails model) {
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("rewardsRate")) {
                this.rewardsRate(model.getRewardsRate());
            }
            if (model.wasPropertyExplicitlySet("totalRewardsAvailable")) {
                this.totalRewardsAvailable(model.getTotalRewardsAvailable());
            }
            if (model.wasPropertyExplicitlySet("redemptionCode")) {
                this.redemptionCode(model.getRedemptionCode());
            }
            return this;
        }
    }
}

