/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonthlyRewardSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availableRewards")
    private final Float availableRewards;
    @JsonProperty(value="redeemedRewards")
    private final Float redeemedRewards;
    @JsonProperty(value="earnedRewards")
    private final Float earnedRewards;
    @JsonProperty(value="isManual")
    private final Boolean isManual;
    @JsonProperty(value="timeRewardsExpired")
    private final Date timeRewardsExpired;
    @JsonProperty(value="timeRewardsEarned")
    private final Date timeRewardsEarned;
    @JsonProperty(value="timeUsageStarted")
    private final Date timeUsageStarted;
    @JsonProperty(value="timeUsageEnded")
    private final Date timeUsageEnded;
    @JsonProperty(value="usageAmount")
    private final Double usageAmount;
    @JsonProperty(value="eligibleUsageAmount")
    private final Double eligibleUsageAmount;
    @JsonProperty(value="ineligibleUsageAmount")
    private final Double ineligibleUsageAmount;
    @JsonProperty(value="usagePeriodKey")
    private final String usagePeriodKey;

    @Deprecated
    @ConstructorProperties(value={"availableRewards", "redeemedRewards", "earnedRewards", "isManual", "timeRewardsExpired", "timeRewardsEarned", "timeUsageStarted", "timeUsageEnded", "usageAmount", "eligibleUsageAmount", "ineligibleUsageAmount", "usagePeriodKey"})
    public MonthlyRewardSummary(Float availableRewards, Float redeemedRewards, Float earnedRewards, Boolean isManual, Date timeRewardsExpired, Date timeRewardsEarned, Date timeUsageStarted, Date timeUsageEnded, Double usageAmount, Double eligibleUsageAmount, Double ineligibleUsageAmount, String usagePeriodKey) {
        this.availableRewards = availableRewards;
        this.redeemedRewards = redeemedRewards;
        this.earnedRewards = earnedRewards;
        this.isManual = isManual;
        this.timeRewardsExpired = timeRewardsExpired;
        this.timeRewardsEarned = timeRewardsEarned;
        this.timeUsageStarted = timeUsageStarted;
        this.timeUsageEnded = timeUsageEnded;
        this.usageAmount = usageAmount;
        this.eligibleUsageAmount = eligibleUsageAmount;
        this.ineligibleUsageAmount = ineligibleUsageAmount;
        this.usagePeriodKey = usagePeriodKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getAvailableRewards() {
        return this.availableRewards;
    }

    public Float getRedeemedRewards() {
        return this.redeemedRewards;
    }

    public Float getEarnedRewards() {
        return this.earnedRewards;
    }

    public Boolean getIsManual() {
        return this.isManual;
    }

    public Date getTimeRewardsExpired() {
        return this.timeRewardsExpired;
    }

    public Date getTimeRewardsEarned() {
        return this.timeRewardsEarned;
    }

    public Date getTimeUsageStarted() {
        return this.timeUsageStarted;
    }

    public Date getTimeUsageEnded() {
        return this.timeUsageEnded;
    }

    public Double getUsageAmount() {
        return this.usageAmount;
    }

    public Double getEligibleUsageAmount() {
        return this.eligibleUsageAmount;
    }

    public Double getIneligibleUsageAmount() {
        return this.ineligibleUsageAmount;
    }

    public String getUsagePeriodKey() {
        return this.usagePeriodKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonthlyRewardSummary(");
        sb.append("super=").append(super.toString());
        sb.append("availableRewards=").append(String.valueOf(this.availableRewards));
        sb.append(", redeemedRewards=").append(String.valueOf(this.redeemedRewards));
        sb.append(", earnedRewards=").append(String.valueOf(this.earnedRewards));
        sb.append(", isManual=").append(String.valueOf(this.isManual));
        sb.append(", timeRewardsExpired=").append(String.valueOf(this.timeRewardsExpired));
        sb.append(", timeRewardsEarned=").append(String.valueOf(this.timeRewardsEarned));
        sb.append(", timeUsageStarted=").append(String.valueOf(this.timeUsageStarted));
        sb.append(", timeUsageEnded=").append(String.valueOf(this.timeUsageEnded));
        sb.append(", usageAmount=").append(String.valueOf(this.usageAmount));
        sb.append(", eligibleUsageAmount=").append(String.valueOf(this.eligibleUsageAmount));
        sb.append(", ineligibleUsageAmount=").append(String.valueOf(this.ineligibleUsageAmount));
        sb.append(", usagePeriodKey=").append(String.valueOf(this.usagePeriodKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonthlyRewardSummary)) {
            return false;
        }
        MonthlyRewardSummary other = (MonthlyRewardSummary)((Object)o);
        return Objects.equals(this.availableRewards, other.availableRewards) && Objects.equals(this.redeemedRewards, other.redeemedRewards) && Objects.equals(this.earnedRewards, other.earnedRewards) && Objects.equals(this.isManual, other.isManual) && Objects.equals(this.timeRewardsExpired, other.timeRewardsExpired) && Objects.equals(this.timeRewardsEarned, other.timeRewardsEarned) && Objects.equals(this.timeUsageStarted, other.timeUsageStarted) && Objects.equals(this.timeUsageEnded, other.timeUsageEnded) && Objects.equals(this.usageAmount, other.usageAmount) && Objects.equals(this.eligibleUsageAmount, other.eligibleUsageAmount) && Objects.equals(this.ineligibleUsageAmount, other.ineligibleUsageAmount) && Objects.equals(this.usagePeriodKey, other.usagePeriodKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availableRewards == null ? 43 : this.availableRewards.hashCode());
        result = result * 59 + (this.redeemedRewards == null ? 43 : this.redeemedRewards.hashCode());
        result = result * 59 + (this.earnedRewards == null ? 43 : this.earnedRewards.hashCode());
        result = result * 59 + (this.isManual == null ? 43 : this.isManual.hashCode());
        result = result * 59 + (this.timeRewardsExpired == null ? 43 : this.timeRewardsExpired.hashCode());
        result = result * 59 + (this.timeRewardsEarned == null ? 43 : this.timeRewardsEarned.hashCode());
        result = result * 59 + (this.timeUsageStarted == null ? 43 : this.timeUsageStarted.hashCode());
        result = result * 59 + (this.timeUsageEnded == null ? 43 : this.timeUsageEnded.hashCode());
        result = result * 59 + (this.usageAmount == null ? 43 : this.usageAmount.hashCode());
        result = result * 59 + (this.eligibleUsageAmount == null ? 43 : this.eligibleUsageAmount.hashCode());
        result = result * 59 + (this.ineligibleUsageAmount == null ? 43 : this.ineligibleUsageAmount.hashCode());
        result = result * 59 + (this.usagePeriodKey == null ? 43 : this.usagePeriodKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availableRewards")
        private Float availableRewards;
        @JsonProperty(value="redeemedRewards")
        private Float redeemedRewards;
        @JsonProperty(value="earnedRewards")
        private Float earnedRewards;
        @JsonProperty(value="isManual")
        private Boolean isManual;
        @JsonProperty(value="timeRewardsExpired")
        private Date timeRewardsExpired;
        @JsonProperty(value="timeRewardsEarned")
        private Date timeRewardsEarned;
        @JsonProperty(value="timeUsageStarted")
        private Date timeUsageStarted;
        @JsonProperty(value="timeUsageEnded")
        private Date timeUsageEnded;
        @JsonProperty(value="usageAmount")
        private Double usageAmount;
        @JsonProperty(value="eligibleUsageAmount")
        private Double eligibleUsageAmount;
        @JsonProperty(value="ineligibleUsageAmount")
        private Double ineligibleUsageAmount;
        @JsonProperty(value="usagePeriodKey")
        private String usagePeriodKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availableRewards(Float availableRewards) {
            this.availableRewards = availableRewards;
            this.__explicitlySet__.add("availableRewards");
            return this;
        }

        public Builder redeemedRewards(Float redeemedRewards) {
            this.redeemedRewards = redeemedRewards;
            this.__explicitlySet__.add("redeemedRewards");
            return this;
        }

        public Builder earnedRewards(Float earnedRewards) {
            this.earnedRewards = earnedRewards;
            this.__explicitlySet__.add("earnedRewards");
            return this;
        }

        public Builder isManual(Boolean isManual) {
            this.isManual = isManual;
            this.__explicitlySet__.add("isManual");
            return this;
        }

        public Builder timeRewardsExpired(Date timeRewardsExpired) {
            this.timeRewardsExpired = timeRewardsExpired;
            this.__explicitlySet__.add("timeRewardsExpired");
            return this;
        }

        public Builder timeRewardsEarned(Date timeRewardsEarned) {
            this.timeRewardsEarned = timeRewardsEarned;
            this.__explicitlySet__.add("timeRewardsEarned");
            return this;
        }

        public Builder timeUsageStarted(Date timeUsageStarted) {
            this.timeUsageStarted = timeUsageStarted;
            this.__explicitlySet__.add("timeUsageStarted");
            return this;
        }

        public Builder timeUsageEnded(Date timeUsageEnded) {
            this.timeUsageEnded = timeUsageEnded;
            this.__explicitlySet__.add("timeUsageEnded");
            return this;
        }

        public Builder usageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
            this.__explicitlySet__.add("usageAmount");
            return this;
        }

        public Builder eligibleUsageAmount(Double eligibleUsageAmount) {
            this.eligibleUsageAmount = eligibleUsageAmount;
            this.__explicitlySet__.add("eligibleUsageAmount");
            return this;
        }

        public Builder ineligibleUsageAmount(Double ineligibleUsageAmount) {
            this.ineligibleUsageAmount = ineligibleUsageAmount;
            this.__explicitlySet__.add("ineligibleUsageAmount");
            return this;
        }

        public Builder usagePeriodKey(String usagePeriodKey) {
            this.usagePeriodKey = usagePeriodKey;
            this.__explicitlySet__.add("usagePeriodKey");
            return this;
        }

        public MonthlyRewardSummary build() {
            MonthlyRewardSummary model = new MonthlyRewardSummary(this.availableRewards, this.redeemedRewards, this.earnedRewards, this.isManual, this.timeRewardsExpired, this.timeRewardsEarned, this.timeUsageStarted, this.timeUsageEnded, this.usageAmount, this.eligibleUsageAmount, this.ineligibleUsageAmount, this.usagePeriodKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonthlyRewardSummary model) {
            if (model.wasPropertyExplicitlySet("availableRewards")) {
                this.availableRewards(model.getAvailableRewards());
            }
            if (model.wasPropertyExplicitlySet("redeemedRewards")) {
                this.redeemedRewards(model.getRedeemedRewards());
            }
            if (model.wasPropertyExplicitlySet("earnedRewards")) {
                this.earnedRewards(model.getEarnedRewards());
            }
            if (model.wasPropertyExplicitlySet("isManual")) {
                this.isManual(model.getIsManual());
            }
            if (model.wasPropertyExplicitlySet("timeRewardsExpired")) {
                this.timeRewardsExpired(model.getTimeRewardsExpired());
            }
            if (model.wasPropertyExplicitlySet("timeRewardsEarned")) {
                this.timeRewardsEarned(model.getTimeRewardsEarned());
            }
            if (model.wasPropertyExplicitlySet("timeUsageStarted")) {
                this.timeUsageStarted(model.getTimeUsageStarted());
            }
            if (model.wasPropertyExplicitlySet("timeUsageEnded")) {
                this.timeUsageEnded(model.getTimeUsageEnded());
            }
            if (model.wasPropertyExplicitlySet("usageAmount")) {
                this.usageAmount(model.getUsageAmount());
            }
            if (model.wasPropertyExplicitlySet("eligibleUsageAmount")) {
                this.eligibleUsageAmount(model.getEligibleUsageAmount());
            }
            if (model.wasPropertyExplicitlySet("ineligibleUsageAmount")) {
                this.ineligibleUsageAmount(model.getIneligibleUsageAmount());
            }
            if (model.wasPropertyExplicitlySet("usagePeriodKey")) {
                this.usagePeriodKey(model.getUsagePeriodKey());
            }
            return this;
        }
    }
}

