/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.usage.Rewards;
import com.oracle.bmc.usage.model.ProductSummary;
import com.oracle.bmc.usage.model.RedeemableUserSummary;
import com.oracle.bmc.usage.model.RedemptionSummary;
import com.oracle.bmc.usage.requests.ListProductsRequest;
import com.oracle.bmc.usage.requests.ListRedeemableUsersRequest;
import com.oracle.bmc.usage.requests.ListRedemptionsRequest;
import com.oracle.bmc.usage.responses.ListProductsResponse;
import com.oracle.bmc.usage.responses.ListRedeemableUsersResponse;
import com.oracle.bmc.usage.responses.ListRedemptionsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RewardsPaginators {
    private final Rewards client;

    public RewardsPaginators(Rewards client) {
        this.client = client;
    }

    public Iterable<ListProductsResponse> listProductsResponseIterator(final ListProductsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProductsRequest.Builder>(){

            @Override
            public ListProductsRequest.Builder get() {
                return ListProductsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductsResponse, String>(){

            @Override
            public String apply(ListProductsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductsRequest.Builder>, ListProductsRequest>(){

            @Override
            public ListProductsRequest apply(RequestBuilderAndToken<ListProductsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductsRequest, ListProductsResponse>(){

            @Override
            public ListProductsResponse apply(ListProductsRequest request) {
                return RewardsPaginators.this.client.listProducts(request);
            }
        });
    }

    public Iterable<ProductSummary> listProductsRecordIterator(final ListProductsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProductsRequest.Builder>(){

            @Override
            public ListProductsRequest.Builder get() {
                return ListProductsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProductsResponse, String>(){

            @Override
            public String apply(ListProductsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProductsRequest.Builder>, ListProductsRequest>(){

            @Override
            public ListProductsRequest apply(RequestBuilderAndToken<ListProductsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProductsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProductsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProductsRequest, ListProductsResponse>(){

            @Override
            public ListProductsResponse apply(ListProductsRequest request) {
                return RewardsPaginators.this.client.listProducts(request);
            }
        }, (Function)new Function<ListProductsResponse, List<ProductSummary>>(){

            @Override
            public List<ProductSummary> apply(ListProductsResponse response) {
                return response.getProductCollection().getItems();
            }
        });
    }

    public Iterable<ListRedeemableUsersResponse> listRedeemableUsersResponseIterator(final ListRedeemableUsersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRedeemableUsersRequest.Builder>(){

            @Override
            public ListRedeemableUsersRequest.Builder get() {
                return ListRedeemableUsersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRedeemableUsersResponse, String>(){

            @Override
            public String apply(ListRedeemableUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRedeemableUsersRequest.Builder>, ListRedeemableUsersRequest>(){

            @Override
            public ListRedeemableUsersRequest apply(RequestBuilderAndToken<ListRedeemableUsersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRedeemableUsersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRedeemableUsersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRedeemableUsersRequest, ListRedeemableUsersResponse>(){

            @Override
            public ListRedeemableUsersResponse apply(ListRedeemableUsersRequest request) {
                return RewardsPaginators.this.client.listRedeemableUsers(request);
            }
        });
    }

    public Iterable<RedeemableUserSummary> listRedeemableUsersRecordIterator(final ListRedeemableUsersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRedeemableUsersRequest.Builder>(){

            @Override
            public ListRedeemableUsersRequest.Builder get() {
                return ListRedeemableUsersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRedeemableUsersResponse, String>(){

            @Override
            public String apply(ListRedeemableUsersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRedeemableUsersRequest.Builder>, ListRedeemableUsersRequest>(){

            @Override
            public ListRedeemableUsersRequest apply(RequestBuilderAndToken<ListRedeemableUsersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRedeemableUsersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRedeemableUsersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRedeemableUsersRequest, ListRedeemableUsersResponse>(){

            @Override
            public ListRedeemableUsersResponse apply(ListRedeemableUsersRequest request) {
                return RewardsPaginators.this.client.listRedeemableUsers(request);
            }
        }, (Function)new Function<ListRedeemableUsersResponse, List<RedeemableUserSummary>>(){

            @Override
            public List<RedeemableUserSummary> apply(ListRedeemableUsersResponse response) {
                return response.getRedeemableUserCollection().getItems();
            }
        });
    }

    public Iterable<ListRedemptionsResponse> listRedemptionsResponseIterator(final ListRedemptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRedemptionsRequest.Builder>(){

            @Override
            public ListRedemptionsRequest.Builder get() {
                return ListRedemptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRedemptionsResponse, String>(){

            @Override
            public String apply(ListRedemptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRedemptionsRequest.Builder>, ListRedemptionsRequest>(){

            @Override
            public ListRedemptionsRequest apply(RequestBuilderAndToken<ListRedemptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRedemptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRedemptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRedemptionsRequest, ListRedemptionsResponse>(){

            @Override
            public ListRedemptionsResponse apply(ListRedemptionsRequest request) {
                return RewardsPaginators.this.client.listRedemptions(request);
            }
        });
    }

    public Iterable<RedemptionSummary> listRedemptionsRecordIterator(final ListRedemptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRedemptionsRequest.Builder>(){

            @Override
            public ListRedemptionsRequest.Builder get() {
                return ListRedemptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRedemptionsResponse, String>(){

            @Override
            public String apply(ListRedemptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRedemptionsRequest.Builder>, ListRedemptionsRequest>(){

            @Override
            public ListRedemptionsRequest apply(RequestBuilderAndToken<ListRedemptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRedemptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRedemptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRedemptionsRequest, ListRedemptionsResponse>(){

            @Override
            public ListRedemptionsResponse apply(ListRedemptionsRequest request) {
                return RewardsPaginators.this.client.listRedemptions(request);
            }
        }, (Function)new Function<ListRedemptionsResponse, List<RedemptionSummary>>(){

            @Override
            public List<RedemptionSummary> apply(ListRedemptionsResponse response) {
                return response.getRedemptionCollection().getItems();
            }
        });
    }
}

