/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIndicatorRequest
extends BmcRequest<Void> {
    private String indicatorId;
    private String compartmentId;
    private String opcRequestId;

    public String getIndicatorId() {
        return this.indicatorId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().indicatorId(this.indicatorId).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",indicatorId=").append(String.valueOf(this.indicatorId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIndicatorRequest)) {
            return false;
        }
        GetIndicatorRequest other = (GetIndicatorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.indicatorId, other.indicatorId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.indicatorId == null ? 43 : this.indicatorId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIndicatorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String indicatorId = null;
        private String compartmentId = null;
        private String opcRequestId = null;

        public Builder indicatorId(String indicatorId) {
            this.indicatorId = indicatorId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIndicatorRequest o) {
            this.indicatorId(o.getIndicatorId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIndicatorRequest build() {
            GetIndicatorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIndicatorRequest buildWithoutInvocationCallback() {
            GetIndicatorRequest request = new GetIndicatorRequest();
            request.indicatorId = this.indicatorId;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

