/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.threatintelligence.model.DataVisibility;
import com.oracle.bmc.threatintelligence.model.IndicatorSourceSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataAttribution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="confidence")
    private final Integer confidence;
    @JsonProperty(value="source")
    private final IndicatorSourceSummary source;
    @JsonProperty(value="visibility")
    private final DataVisibility visibility;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"confidence", "source", "visibility", "timeFirstSeen", "timeLastSeen"})
    public DataAttribution(Integer confidence, IndicatorSourceSummary source, DataVisibility visibility, Date timeFirstSeen, Date timeLastSeen) {
        this.confidence = confidence;
        this.source = source;
        this.visibility = visibility;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public IndicatorSourceSummary getSource() {
        return this.source;
    }

    public DataVisibility getVisibility() {
        return this.visibility;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAttribution(");
        sb.append("super=").append(super.toString());
        sb.append("confidence=").append(String.valueOf(this.confidence));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", visibility=").append(String.valueOf((Object)this.visibility));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAttribution)) {
            return false;
        }
        DataAttribution other = (DataAttribution)((Object)o);
        return Objects.equals(this.confidence, other.confidence) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals((Object)this.visibility, (Object)other.visibility) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.visibility == null ? 43 : this.visibility.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="confidence")
        private Integer confidence;
        @JsonProperty(value="source")
        private IndicatorSourceSummary source;
        @JsonProperty(value="visibility")
        private DataVisibility visibility;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder source(IndicatorSourceSummary source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder visibility(DataVisibility visibility) {
            this.visibility = visibility;
            this.__explicitlySet__.add("visibility");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public DataAttribution build() {
            DataAttribution model = new DataAttribution(this.confidence, this.source, this.visibility, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataAttribution model) {
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("visibility")) {
                this.visibility(model.getVisibility());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

