/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence;

import com.oracle.bmc.threatintelligence.Threatintel;
import com.oracle.bmc.threatintelligence.model.LifecycleState;
import com.oracle.bmc.threatintelligence.requests.GetIndicatorRequest;
import com.oracle.bmc.threatintelligence.responses.GetIndicatorResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ThreatintelWaiters {
    private final ExecutorService executorService;
    private final Threatintel client;

    public ThreatintelWaiters(ExecutorService executorService, Threatintel client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetIndicatorRequest, GetIndicatorResponse> forIndicator(GetIndicatorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIndicator(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIndicatorRequest, GetIndicatorResponse> forIndicator(GetIndicatorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIndicator(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIndicatorRequest, GetIndicatorResponse> forIndicator(GetIndicatorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIndicator(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIndicatorRequest, GetIndicatorResponse> forIndicator(BmcGenericWaiter waiter, GetIndicatorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIndicatorRequest, GetIndicatorResponse>(){

            @Override
            public GetIndicatorResponse apply(GetIndicatorRequest request) {
                return ThreatintelWaiters.this.client.getIndicator(request);
            }
        }, (Predicate)new Predicate<GetIndicatorResponse>(){

            @Override
            public boolean test(GetIndicatorResponse response) {
                return targetStatesSet.contains((Object)response.getIndicator().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }
}

