/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.threatintelligence.Threatintel;
import com.oracle.bmc.threatintelligence.model.IndicatorSummary;
import com.oracle.bmc.threatintelligence.model.ThreatTypeSummary;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorsRequest;
import com.oracle.bmc.threatintelligence.requests.ListThreatTypesRequest;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorsResponse;
import com.oracle.bmc.threatintelligence.responses.ListThreatTypesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ThreatintelPaginators {
    private final Threatintel client;

    public ThreatintelPaginators(Threatintel client) {
        this.client = client;
    }

    public Iterable<ListIndicatorsResponse> listIndicatorsResponseIterator(final ListIndicatorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIndicatorsRequest.Builder>(){

            @Override
            public ListIndicatorsRequest.Builder get() {
                return ListIndicatorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndicatorsResponse, String>(){

            @Override
            public String apply(ListIndicatorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndicatorsRequest.Builder>, ListIndicatorsRequest>(){

            @Override
            public ListIndicatorsRequest apply(RequestBuilderAndToken<ListIndicatorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIndicatorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndicatorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIndicatorsRequest, ListIndicatorsResponse>(){

            @Override
            public ListIndicatorsResponse apply(ListIndicatorsRequest request) {
                return ThreatintelPaginators.this.client.listIndicators(request);
            }
        });
    }

    public Iterable<IndicatorSummary> listIndicatorsRecordIterator(final ListIndicatorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIndicatorsRequest.Builder>(){

            @Override
            public ListIndicatorsRequest.Builder get() {
                return ListIndicatorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndicatorsResponse, String>(){

            @Override
            public String apply(ListIndicatorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndicatorsRequest.Builder>, ListIndicatorsRequest>(){

            @Override
            public ListIndicatorsRequest apply(RequestBuilderAndToken<ListIndicatorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIndicatorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndicatorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIndicatorsRequest, ListIndicatorsResponse>(){

            @Override
            public ListIndicatorsResponse apply(ListIndicatorsRequest request) {
                return ThreatintelPaginators.this.client.listIndicators(request);
            }
        }, (Function)new Function<ListIndicatorsResponse, List<IndicatorSummary>>(){

            @Override
            public List<IndicatorSummary> apply(ListIndicatorsResponse response) {
                return response.getIndicatorSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListThreatTypesResponse> listThreatTypesResponseIterator(final ListThreatTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListThreatTypesRequest.Builder>(){

            @Override
            public ListThreatTypesRequest.Builder get() {
                return ListThreatTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListThreatTypesResponse, String>(){

            @Override
            public String apply(ListThreatTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListThreatTypesRequest.Builder>, ListThreatTypesRequest>(){

            @Override
            public ListThreatTypesRequest apply(RequestBuilderAndToken<ListThreatTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListThreatTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListThreatTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListThreatTypesRequest, ListThreatTypesResponse>(){

            @Override
            public ListThreatTypesResponse apply(ListThreatTypesRequest request) {
                return ThreatintelPaginators.this.client.listThreatTypes(request);
            }
        });
    }

    public Iterable<ThreatTypeSummary> listThreatTypesRecordIterator(final ListThreatTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListThreatTypesRequest.Builder>(){

            @Override
            public ListThreatTypesRequest.Builder get() {
                return ListThreatTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListThreatTypesResponse, String>(){

            @Override
            public String apply(ListThreatTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListThreatTypesRequest.Builder>, ListThreatTypesRequest>(){

            @Override
            public ListThreatTypesRequest apply(RequestBuilderAndToken<ListThreatTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListThreatTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListThreatTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListThreatTypesRequest, ListThreatTypesResponse>(){

            @Override
            public ListThreatTypesResponse apply(ListThreatTypesRequest request) {
                return ThreatintelPaginators.this.client.listThreatTypes(request);
            }
        }, (Function)new Function<ListThreatTypesResponse, List<ThreatTypeSummary>>(){

            @Override
            public List<ThreatTypeSummary> apply(ListThreatTypesResponse response) {
                return response.getThreatTypesCollection().getItems();
            }
        });
    }
}

