/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateStreamDetails;
import java.util.Objects;

public class UpdateStreamRequest
extends BmcRequest<UpdateStreamDetails> {
    private String streamId;
    private UpdateStreamDetails updateStreamDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getStreamId() {
        return this.streamId;
    }

    public UpdateStreamDetails getUpdateStreamDetails() {
        return this.updateStreamDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateStreamDetails getBody$() {
        return this.updateStreamDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).updateStreamDetails(this.updateStreamDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",updateStreamDetails=").append(String.valueOf((Object)this.updateStreamDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateStreamRequest)) {
            return false;
        }
        UpdateStreamRequest other = (UpdateStreamRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.updateStreamDetails, (Object)other.updateStreamDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.updateStreamDetails == null ? 43 : this.updateStreamDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateStreamRequest, UpdateStreamDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private UpdateStreamDetails updateStreamDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder updateStreamDetails(UpdateStreamDetails updateStreamDetails) {
            this.updateStreamDetails = updateStreamDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStreamRequest o) {
            this.streamId(o.getStreamId());
            this.updateStreamDetails(o.getUpdateStreamDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStreamRequest build() {
            UpdateStreamRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateStreamDetails body) {
            this.updateStreamDetails(body);
            return this;
        }

        public UpdateStreamRequest buildWithoutInvocationCallback() {
            UpdateStreamRequest request = new UpdateStreamRequest();
            request.streamId = this.streamId;
            request.updateStreamDetails = this.updateStreamDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

