/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConnectHarnessRequest
extends BmcRequest<Void> {
    private String connectHarnessId;
    private String opcRequestId;

    public String getConnectHarnessId() {
        return this.connectHarnessId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().connectHarnessId(this.connectHarnessId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",connectHarnessId=").append(String.valueOf(this.connectHarnessId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConnectHarnessRequest)) {
            return false;
        }
        GetConnectHarnessRequest other = (GetConnectHarnessRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.connectHarnessId, other.connectHarnessId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectHarnessId == null ? 43 : this.connectHarnessId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConnectHarnessRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String connectHarnessId = null;
        private String opcRequestId = null;

        public Builder connectHarnessId(String connectHarnessId) {
            this.connectHarnessId = connectHarnessId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectHarnessRequest o) {
            this.connectHarnessId(o.getConnectHarnessId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectHarnessRequest build() {
            GetConnectHarnessRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConnectHarnessRequest buildWithoutInvocationCallback() {
            GetConnectHarnessRequest request = new GetConnectHarnessRequest();
            request.connectHarnessId = this.connectHarnessId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

