/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.ChangeStreamCompartmentDetails;
import java.util.Objects;

public class ChangeStreamCompartmentRequest
extends BmcRequest<ChangeStreamCompartmentDetails> {
    private String streamId;
    private ChangeStreamCompartmentDetails changeStreamCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public ChangeStreamCompartmentDetails getChangeStreamCompartmentDetails() {
        return this.changeStreamCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeStreamCompartmentDetails getBody$() {
        return this.changeStreamCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).changeStreamCompartmentDetails(this.changeStreamCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",changeStreamCompartmentDetails=").append(String.valueOf((Object)this.changeStreamCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeStreamCompartmentRequest)) {
            return false;
        }
        ChangeStreamCompartmentRequest other = (ChangeStreamCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.changeStreamCompartmentDetails, (Object)other.changeStreamCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.changeStreamCompartmentDetails == null ? 43 : this.changeStreamCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeStreamCompartmentRequest, ChangeStreamCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private ChangeStreamCompartmentDetails changeStreamCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder changeStreamCompartmentDetails(ChangeStreamCompartmentDetails changeStreamCompartmentDetails) {
            this.changeStreamCompartmentDetails = changeStreamCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeStreamCompartmentRequest o) {
            this.streamId(o.getStreamId());
            this.changeStreamCompartmentDetails(o.getChangeStreamCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeStreamCompartmentRequest build() {
            ChangeStreamCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeStreamCompartmentDetails body) {
            this.changeStreamCompartmentDetails(body);
            return this;
        }

        public ChangeStreamCompartmentRequest buildWithoutInvocationCallback() {
            ChangeStreamCompartmentRequest request = new ChangeStreamCompartmentRequest();
            request.streamId = this.streamId;
            request.changeStreamCompartmentDetails = this.changeStreamCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

