/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.model.ConnectHarnessSummary;
import com.oracle.bmc.streaming.model.StreamPoolSummary;
import com.oracle.bmc.streaming.model.StreamSummary;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class StreamAdminPaginators {
    private final StreamAdmin client;

    public StreamAdminPaginators(StreamAdmin client) {
        this.client = client;
    }

    public Iterable<ListConnectHarnessesResponse> listConnectHarnessesResponseIterator(final ListConnectHarnessesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectHarnessesRequest.Builder>(){

            @Override
            public ListConnectHarnessesRequest.Builder get() {
                return ListConnectHarnessesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectHarnessesResponse, String>(){

            @Override
            public String apply(ListConnectHarnessesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectHarnessesRequest.Builder>, ListConnectHarnessesRequest>(){

            @Override
            public ListConnectHarnessesRequest apply(RequestBuilderAndToken<ListConnectHarnessesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectHarnessesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectHarnessesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectHarnessesRequest, ListConnectHarnessesResponse>(){

            @Override
            public ListConnectHarnessesResponse apply(ListConnectHarnessesRequest request) {
                return StreamAdminPaginators.this.client.listConnectHarnesses(request);
            }
        });
    }

    public Iterable<ConnectHarnessSummary> listConnectHarnessesRecordIterator(final ListConnectHarnessesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectHarnessesRequest.Builder>(){

            @Override
            public ListConnectHarnessesRequest.Builder get() {
                return ListConnectHarnessesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectHarnessesResponse, String>(){

            @Override
            public String apply(ListConnectHarnessesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectHarnessesRequest.Builder>, ListConnectHarnessesRequest>(){

            @Override
            public ListConnectHarnessesRequest apply(RequestBuilderAndToken<ListConnectHarnessesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectHarnessesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectHarnessesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectHarnessesRequest, ListConnectHarnessesResponse>(){

            @Override
            public ListConnectHarnessesResponse apply(ListConnectHarnessesRequest request) {
                return StreamAdminPaginators.this.client.listConnectHarnesses(request);
            }
        }, (Function)new Function<ListConnectHarnessesResponse, List<ConnectHarnessSummary>>(){

            @Override
            public List<ConnectHarnessSummary> apply(ListConnectHarnessesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListStreamPoolsResponse> listStreamPoolsResponseIterator(final ListStreamPoolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStreamPoolsRequest.Builder>(){

            @Override
            public ListStreamPoolsRequest.Builder get() {
                return ListStreamPoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamPoolsResponse, String>(){

            @Override
            public String apply(ListStreamPoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamPoolsRequest.Builder>, ListStreamPoolsRequest>(){

            @Override
            public ListStreamPoolsRequest apply(RequestBuilderAndToken<ListStreamPoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamPoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamPoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamPoolsRequest, ListStreamPoolsResponse>(){

            @Override
            public ListStreamPoolsResponse apply(ListStreamPoolsRequest request) {
                return StreamAdminPaginators.this.client.listStreamPools(request);
            }
        });
    }

    public Iterable<StreamPoolSummary> listStreamPoolsRecordIterator(final ListStreamPoolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStreamPoolsRequest.Builder>(){

            @Override
            public ListStreamPoolsRequest.Builder get() {
                return ListStreamPoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamPoolsResponse, String>(){

            @Override
            public String apply(ListStreamPoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamPoolsRequest.Builder>, ListStreamPoolsRequest>(){

            @Override
            public ListStreamPoolsRequest apply(RequestBuilderAndToken<ListStreamPoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamPoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamPoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamPoolsRequest, ListStreamPoolsResponse>(){

            @Override
            public ListStreamPoolsResponse apply(ListStreamPoolsRequest request) {
                return StreamAdminPaginators.this.client.listStreamPools(request);
            }
        }, (Function)new Function<ListStreamPoolsResponse, List<StreamPoolSummary>>(){

            @Override
            public List<StreamPoolSummary> apply(ListStreamPoolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListStreamsResponse> listStreamsResponseIterator(final ListStreamsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStreamsRequest.Builder>(){

            @Override
            public ListStreamsRequest.Builder get() {
                return ListStreamsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamsResponse, String>(){

            @Override
            public String apply(ListStreamsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamsRequest.Builder>, ListStreamsRequest>(){

            @Override
            public ListStreamsRequest apply(RequestBuilderAndToken<ListStreamsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamsRequest, ListStreamsResponse>(){

            @Override
            public ListStreamsResponse apply(ListStreamsRequest request) {
                return StreamAdminPaginators.this.client.listStreams(request);
            }
        });
    }

    public Iterable<StreamSummary> listStreamsRecordIterator(final ListStreamsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStreamsRequest.Builder>(){

            @Override
            public ListStreamsRequest.Builder get() {
                return ListStreamsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStreamsResponse, String>(){

            @Override
            public String apply(ListStreamsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStreamsRequest.Builder>, ListStreamsRequest>(){

            @Override
            public ListStreamsRequest apply(RequestBuilderAndToken<ListStreamsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStreamsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStreamsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStreamsRequest, ListStreamsResponse>(){

            @Override
            public ListStreamsResponse apply(ListStreamsRequest request) {
                return StreamAdminPaginators.this.client.listStreams(request);
            }
        }, (Function)new Function<ListStreamsResponse, List<StreamSummary>>(){

            @Override
            public List<StreamSummary> apply(ListStreamsResponse response) {
                return response.getItems();
            }
        });
    }
}

