/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.servicemesh.model.MeshCollection;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListMeshesResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private MeshCollection meshCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public MeshCollection getMeshCollection() {
        return this.meshCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "meshCollection"})
    private ListMeshesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, MeshCollection meshCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.meshCollection = meshCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",meshCollection=").append(String.valueOf((Object)this.meshCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMeshesResponse)) {
            return false;
        }
        ListMeshesResponse other = (ListMeshesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.meshCollection, (Object)other.meshCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.meshCollection == null ? 43 : this.meshCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListMeshesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private MeshCollection meshCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder meshCollection(MeshCollection meshCollection) {
            this.meshCollection = meshCollection;
            return this;
        }

        public Builder copy(ListMeshesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.meshCollection(o.getMeshCollection());
            return this;
        }

        public ListMeshesResponse build() {
            return new ListMeshesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.meshCollection);
        }
    }
}

