/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicemesh.model.UpdateMeshDetails;
import java.util.Objects;

public class UpdateMeshRequest
extends BmcRequest<UpdateMeshDetails> {
    private String meshId;
    private UpdateMeshDetails updateMeshDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getMeshId() {
        return this.meshId;
    }

    public UpdateMeshDetails getUpdateMeshDetails() {
        return this.updateMeshDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMeshDetails getBody$() {
        return this.updateMeshDetails;
    }

    public Builder toBuilder() {
        return new Builder().meshId(this.meshId).updateMeshDetails(this.updateMeshDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",meshId=").append(String.valueOf(this.meshId));
        sb.append(",updateMeshDetails=").append(String.valueOf((Object)this.updateMeshDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMeshRequest)) {
            return false;
        }
        UpdateMeshRequest other = (UpdateMeshRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.meshId, other.meshId) && Objects.equals((Object)this.updateMeshDetails, (Object)other.updateMeshDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.meshId == null ? 43 : this.meshId.hashCode());
        result = result * 59 + (this.updateMeshDetails == null ? 43 : this.updateMeshDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMeshRequest, UpdateMeshDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String meshId = null;
        private UpdateMeshDetails updateMeshDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder meshId(String meshId) {
            this.meshId = meshId;
            return this;
        }

        public Builder updateMeshDetails(UpdateMeshDetails updateMeshDetails) {
            this.updateMeshDetails = updateMeshDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMeshRequest o) {
            this.meshId(o.getMeshId());
            this.updateMeshDetails(o.getUpdateMeshDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMeshRequest build() {
            UpdateMeshRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMeshDetails body) {
            this.updateMeshDetails(body);
            return this;
        }

        public UpdateMeshRequest buildWithoutInvocationCallback() {
            UpdateMeshRequest request = new UpdateMeshRequest();
            request.meshId = this.meshId;
            request.updateMeshDetails = this.updateMeshDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

