/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicemesh.model.ChangeMeshCompartmentDetails;
import java.util.Objects;

public class ChangeMeshCompartmentRequest
extends BmcRequest<ChangeMeshCompartmentDetails> {
    private String meshId;
    private ChangeMeshCompartmentDetails changeMeshCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getMeshId() {
        return this.meshId;
    }

    public ChangeMeshCompartmentDetails getChangeMeshCompartmentDetails() {
        return this.changeMeshCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeMeshCompartmentDetails getBody$() {
        return this.changeMeshCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().meshId(this.meshId).changeMeshCompartmentDetails(this.changeMeshCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",meshId=").append(String.valueOf(this.meshId));
        sb.append(",changeMeshCompartmentDetails=").append(String.valueOf((Object)this.changeMeshCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeMeshCompartmentRequest)) {
            return false;
        }
        ChangeMeshCompartmentRequest other = (ChangeMeshCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.meshId, other.meshId) && Objects.equals((Object)this.changeMeshCompartmentDetails, (Object)other.changeMeshCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.meshId == null ? 43 : this.meshId.hashCode());
        result = result * 59 + (this.changeMeshCompartmentDetails == null ? 43 : this.changeMeshCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeMeshCompartmentRequest, ChangeMeshCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String meshId = null;
        private ChangeMeshCompartmentDetails changeMeshCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder meshId(String meshId) {
            this.meshId = meshId;
            return this;
        }

        public Builder changeMeshCompartmentDetails(ChangeMeshCompartmentDetails changeMeshCompartmentDetails) {
            this.changeMeshCompartmentDetails = changeMeshCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeMeshCompartmentRequest o) {
            this.meshId(o.getMeshId());
            this.changeMeshCompartmentDetails(o.getChangeMeshCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeMeshCompartmentRequest build() {
            ChangeMeshCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeMeshCompartmentDetails body) {
            this.changeMeshCompartmentDetails(body);
            return this;
        }

        public ChangeMeshCompartmentRequest buildWithoutInvocationCallback() {
            ChangeMeshCompartmentRequest request = new ChangeMeshCompartmentRequest();
            request.meshId = this.meshId;
            request.changeMeshCompartmentDetails = this.changeMeshCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

