/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.IngressListenerClientValidationConfig;
import com.oracle.bmc.servicemesh.model.TlsCertificate;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IngressListenerTlsConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="mode")
    private final Mode mode;
    @JsonProperty(value="serverCertificate")
    private final TlsCertificate serverCertificate;
    @JsonProperty(value="clientValidation")
    private final IngressListenerClientValidationConfig clientValidation;

    @Deprecated
    @ConstructorProperties(value={"mode", "serverCertificate", "clientValidation"})
    public IngressListenerTlsConfig(Mode mode, TlsCertificate serverCertificate, IngressListenerClientValidationConfig clientValidation) {
        this.mode = mode;
        this.serverCertificate = serverCertificate;
        this.clientValidation = clientValidation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Mode getMode() {
        return this.mode;
    }

    public TlsCertificate getServerCertificate() {
        return this.serverCertificate;
    }

    public IngressListenerClientValidationConfig getClientValidation() {
        return this.clientValidation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngressListenerTlsConfig(");
        sb.append("super=").append(super.toString());
        sb.append("mode=").append(String.valueOf((Object)this.mode));
        sb.append(", serverCertificate=").append(String.valueOf((Object)this.serverCertificate));
        sb.append(", clientValidation=").append(String.valueOf((Object)this.clientValidation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngressListenerTlsConfig)) {
            return false;
        }
        IngressListenerTlsConfig other = (IngressListenerTlsConfig)((Object)o);
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals((Object)this.serverCertificate, (Object)other.serverCertificate) && Objects.equals((Object)this.clientValidation, (Object)other.clientValidation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + (this.serverCertificate == null ? 43 : this.serverCertificate.hashCode());
        result = result * 59 + (this.clientValidation == null ? 43 : this.clientValidation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Mode implements BmcEnum
    {
        Disabled("DISABLED"),
        Permissive("PERMISSIVE"),
        Tls("TLS"),
        MutualTls("MUTUAL_TLS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Mode> map;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Mode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Mode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Mode.class);
            map = new HashMap<String, Mode>();
            for (Mode v : Mode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mode")
        private Mode mode;
        @JsonProperty(value="serverCertificate")
        private TlsCertificate serverCertificate;
        @JsonProperty(value="clientValidation")
        private IngressListenerClientValidationConfig clientValidation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mode(Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder serverCertificate(TlsCertificate serverCertificate) {
            this.serverCertificate = serverCertificate;
            this.__explicitlySet__.add("serverCertificate");
            return this;
        }

        public Builder clientValidation(IngressListenerClientValidationConfig clientValidation) {
            this.clientValidation = clientValidation;
            this.__explicitlySet__.add("clientValidation");
            return this;
        }

        public IngressListenerTlsConfig build() {
            IngressListenerTlsConfig model = new IngressListenerTlsConfig(this.mode, this.serverCertificate, this.clientValidation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngressListenerTlsConfig model) {
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("serverCertificate")) {
                this.serverCertificate(model.getServerCertificate());
            }
            if (model.wasPropertyExplicitlySet("clientValidation")) {
                this.clientValidation(model.getClientValidation());
            }
            return this;
        }
    }
}

