/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.IngressListenerTlsConfig;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IngressGatewayListener
extends ExplicitlySetBmcModel {
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="tls")
    private final IngressListenerTlsConfig tls;

    @Deprecated
    @ConstructorProperties(value={"protocol", "port", "tls"})
    public IngressGatewayListener(Protocol protocol, Integer port, IngressListenerTlsConfig tls) {
        this.protocol = protocol;
        this.port = port;
        this.tls = tls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public IngressListenerTlsConfig getTls() {
        return this.tls;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngressGatewayListener(");
        sb.append("super=").append(super.toString());
        sb.append("protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", tls=").append(String.valueOf((Object)this.tls));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngressGatewayListener)) {
            return false;
        }
        IngressGatewayListener other = (IngressGatewayListener)((Object)o);
        return Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.port, other.port) && Objects.equals((Object)this.tls, (Object)other.tls) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.tls == null ? 43 : this.tls.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Http("HTTP"),
        TlsPassthrough("TLS_PASSTHROUGH"),
        Tcp("TCP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="tls")
        private IngressListenerTlsConfig tls;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder tls(IngressListenerTlsConfig tls) {
            this.tls = tls;
            this.__explicitlySet__.add("tls");
            return this;
        }

        public IngressGatewayListener build() {
            IngressGatewayListener model = new IngressGatewayListener(this.protocol, this.port, this.tls);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngressGatewayListener model) {
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("tls")) {
                this.tls(model.getTls());
            }
            return this;
        }
    }
}

