/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.VirtualDeploymentTrafficRuleTarget;
import com.oracle.bmc.servicemesh.model.VirtualServiceTrafficRouteRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class HttpVirtualServiceTrafficRouteRule
extends VirtualServiceTrafficRouteRule {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="pathType")
    private final PathType pathType;
    @JsonProperty(value="isGrpc")
    private final Boolean isGrpc;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HttpVirtualServiceTrafficRouteRule(List<VirtualDeploymentTrafficRuleTarget> destinations, String path, PathType pathType, Boolean isGrpc) {
        super(destinations);
        this.path = path;
        this.pathType = pathType;
        this.isGrpc = isGrpc;
    }

    public String getPath() {
        return this.path;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public Boolean getIsGrpc() {
        return this.isGrpc;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpVirtualServiceTrafficRouteRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", pathType=").append(String.valueOf((Object)this.pathType));
        sb.append(", isGrpc=").append(String.valueOf(this.isGrpc));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpVirtualServiceTrafficRouteRule)) {
            return false;
        }
        HttpVirtualServiceTrafficRouteRule other = (HttpVirtualServiceTrafficRouteRule)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals((Object)this.pathType, (Object)other.pathType) && Objects.equals(this.isGrpc, other.isGrpc) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.pathType == null ? 43 : this.pathType.hashCode());
        result = result * 59 + (this.isGrpc == null ? 43 : this.isGrpc.hashCode());
        return result;
    }

    public static enum PathType implements BmcEnum
    {
        Prefix("PREFIX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PathType> map;

        private PathType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PathType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PathType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PathType.class);
            map = new HashMap<String, PathType>();
            for (PathType v : PathType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destinations")
        private List<VirtualDeploymentTrafficRuleTarget> destinations;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="pathType")
        private PathType pathType;
        @JsonProperty(value="isGrpc")
        private Boolean isGrpc;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destinations(List<VirtualDeploymentTrafficRuleTarget> destinations) {
            this.destinations = destinations;
            this.__explicitlySet__.add("destinations");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder pathType(PathType pathType) {
            this.pathType = pathType;
            this.__explicitlySet__.add("pathType");
            return this;
        }

        public Builder isGrpc(Boolean isGrpc) {
            this.isGrpc = isGrpc;
            this.__explicitlySet__.add("isGrpc");
            return this;
        }

        public HttpVirtualServiceTrafficRouteRule build() {
            HttpVirtualServiceTrafficRouteRule model = new HttpVirtualServiceTrafficRouteRule(this.destinations, this.path, this.pathType, this.isGrpc);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpVirtualServiceTrafficRouteRule model) {
            if (model.wasPropertyExplicitlySet("destinations")) {
                this.destinations(model.getDestinations());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("pathType")) {
                this.pathType(model.getPathType());
            }
            if (model.wasPropertyExplicitlySet("isGrpc")) {
                this.isGrpc(model.getIsGrpc());
            }
            return this;
        }
    }
}

