/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.servicemesh.ServiceMesh;
import com.oracle.bmc.servicemesh.model.AccessPolicySummary;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTableSummary;
import com.oracle.bmc.servicemesh.model.IngressGatewaySummary;
import com.oracle.bmc.servicemesh.model.MeshSummary;
import com.oracle.bmc.servicemesh.model.VirtualDeploymentSummary;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTableSummary;
import com.oracle.bmc.servicemesh.model.VirtualServiceSummary;
import com.oracle.bmc.servicemesh.model.WorkRequestError;
import com.oracle.bmc.servicemesh.model.WorkRequestLogEntry;
import com.oracle.bmc.servicemesh.model.WorkRequestSummary;
import com.oracle.bmc.servicemesh.requests.ListAccessPoliciesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewayRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewaysRequest;
import com.oracle.bmc.servicemesh.requests.ListMeshesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualDeploymentsRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServiceRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServicesRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestsRequest;
import com.oracle.bmc.servicemesh.responses.ListAccessPoliciesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewayRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewaysResponse;
import com.oracle.bmc.servicemesh.responses.ListMeshesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualDeploymentsResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServiceRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServicesResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceMeshPaginators {
    private final ServiceMesh client;

    public ServiceMeshPaginators(ServiceMesh client) {
        this.client = client;
    }

    public Iterable<ListAccessPoliciesResponse> listAccessPoliciesResponseIterator(final ListAccessPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAccessPoliciesRequest.Builder>(){

            @Override
            public ListAccessPoliciesRequest.Builder get() {
                return ListAccessPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessPoliciesResponse, String>(){

            @Override
            public String apply(ListAccessPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessPoliciesRequest.Builder>, ListAccessPoliciesRequest>(){

            @Override
            public ListAccessPoliciesRequest apply(RequestBuilderAndToken<ListAccessPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessPoliciesRequest, ListAccessPoliciesResponse>(){

            @Override
            public ListAccessPoliciesResponse apply(ListAccessPoliciesRequest request) {
                return ServiceMeshPaginators.this.client.listAccessPolicies(request);
            }
        });
    }

    public Iterable<AccessPolicySummary> listAccessPoliciesRecordIterator(final ListAccessPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAccessPoliciesRequest.Builder>(){

            @Override
            public ListAccessPoliciesRequest.Builder get() {
                return ListAccessPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessPoliciesResponse, String>(){

            @Override
            public String apply(ListAccessPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessPoliciesRequest.Builder>, ListAccessPoliciesRequest>(){

            @Override
            public ListAccessPoliciesRequest apply(RequestBuilderAndToken<ListAccessPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessPoliciesRequest, ListAccessPoliciesResponse>(){

            @Override
            public ListAccessPoliciesResponse apply(ListAccessPoliciesRequest request) {
                return ServiceMeshPaginators.this.client.listAccessPolicies(request);
            }
        }, (Function)new Function<ListAccessPoliciesResponse, List<AccessPolicySummary>>(){

            @Override
            public List<AccessPolicySummary> apply(ListAccessPoliciesResponse response) {
                return response.getAccessPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListIngressGatewayRouteTablesResponse> listIngressGatewayRouteTablesResponseIterator(final ListIngressGatewayRouteTablesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIngressGatewayRouteTablesRequest.Builder>(){

            @Override
            public ListIngressGatewayRouteTablesRequest.Builder get() {
                return ListIngressGatewayRouteTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIngressGatewayRouteTablesResponse, String>(){

            @Override
            public String apply(ListIngressGatewayRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIngressGatewayRouteTablesRequest.Builder>, ListIngressGatewayRouteTablesRequest>(){

            @Override
            public ListIngressGatewayRouteTablesRequest apply(RequestBuilderAndToken<ListIngressGatewayRouteTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIngressGatewayRouteTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIngressGatewayRouteTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIngressGatewayRouteTablesRequest, ListIngressGatewayRouteTablesResponse>(){

            @Override
            public ListIngressGatewayRouteTablesResponse apply(ListIngressGatewayRouteTablesRequest request) {
                return ServiceMeshPaginators.this.client.listIngressGatewayRouteTables(request);
            }
        });
    }

    public Iterable<IngressGatewayRouteTableSummary> listIngressGatewayRouteTablesRecordIterator(final ListIngressGatewayRouteTablesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIngressGatewayRouteTablesRequest.Builder>(){

            @Override
            public ListIngressGatewayRouteTablesRequest.Builder get() {
                return ListIngressGatewayRouteTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIngressGatewayRouteTablesResponse, String>(){

            @Override
            public String apply(ListIngressGatewayRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIngressGatewayRouteTablesRequest.Builder>, ListIngressGatewayRouteTablesRequest>(){

            @Override
            public ListIngressGatewayRouteTablesRequest apply(RequestBuilderAndToken<ListIngressGatewayRouteTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIngressGatewayRouteTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIngressGatewayRouteTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIngressGatewayRouteTablesRequest, ListIngressGatewayRouteTablesResponse>(){

            @Override
            public ListIngressGatewayRouteTablesResponse apply(ListIngressGatewayRouteTablesRequest request) {
                return ServiceMeshPaginators.this.client.listIngressGatewayRouteTables(request);
            }
        }, (Function)new Function<ListIngressGatewayRouteTablesResponse, List<IngressGatewayRouteTableSummary>>(){

            @Override
            public List<IngressGatewayRouteTableSummary> apply(ListIngressGatewayRouteTablesResponse response) {
                return response.getIngressGatewayRouteTableCollection().getItems();
            }
        });
    }

    public Iterable<ListIngressGatewaysResponse> listIngressGatewaysResponseIterator(final ListIngressGatewaysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIngressGatewaysRequest.Builder>(){

            @Override
            public ListIngressGatewaysRequest.Builder get() {
                return ListIngressGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIngressGatewaysResponse, String>(){

            @Override
            public String apply(ListIngressGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIngressGatewaysRequest.Builder>, ListIngressGatewaysRequest>(){

            @Override
            public ListIngressGatewaysRequest apply(RequestBuilderAndToken<ListIngressGatewaysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIngressGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIngressGatewaysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIngressGatewaysRequest, ListIngressGatewaysResponse>(){

            @Override
            public ListIngressGatewaysResponse apply(ListIngressGatewaysRequest request) {
                return ServiceMeshPaginators.this.client.listIngressGateways(request);
            }
        });
    }

    public Iterable<IngressGatewaySummary> listIngressGatewaysRecordIterator(final ListIngressGatewaysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIngressGatewaysRequest.Builder>(){

            @Override
            public ListIngressGatewaysRequest.Builder get() {
                return ListIngressGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIngressGatewaysResponse, String>(){

            @Override
            public String apply(ListIngressGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIngressGatewaysRequest.Builder>, ListIngressGatewaysRequest>(){

            @Override
            public ListIngressGatewaysRequest apply(RequestBuilderAndToken<ListIngressGatewaysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIngressGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIngressGatewaysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIngressGatewaysRequest, ListIngressGatewaysResponse>(){

            @Override
            public ListIngressGatewaysResponse apply(ListIngressGatewaysRequest request) {
                return ServiceMeshPaginators.this.client.listIngressGateways(request);
            }
        }, (Function)new Function<ListIngressGatewaysResponse, List<IngressGatewaySummary>>(){

            @Override
            public List<IngressGatewaySummary> apply(ListIngressGatewaysResponse response) {
                return response.getIngressGatewayCollection().getItems();
            }
        });
    }

    public Iterable<ListMeshesResponse> listMeshesResponseIterator(final ListMeshesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMeshesRequest.Builder>(){

            @Override
            public ListMeshesRequest.Builder get() {
                return ListMeshesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMeshesResponse, String>(){

            @Override
            public String apply(ListMeshesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMeshesRequest.Builder>, ListMeshesRequest>(){

            @Override
            public ListMeshesRequest apply(RequestBuilderAndToken<ListMeshesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMeshesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMeshesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMeshesRequest, ListMeshesResponse>(){

            @Override
            public ListMeshesResponse apply(ListMeshesRequest request) {
                return ServiceMeshPaginators.this.client.listMeshes(request);
            }
        });
    }

    public Iterable<MeshSummary> listMeshesRecordIterator(final ListMeshesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMeshesRequest.Builder>(){

            @Override
            public ListMeshesRequest.Builder get() {
                return ListMeshesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMeshesResponse, String>(){

            @Override
            public String apply(ListMeshesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMeshesRequest.Builder>, ListMeshesRequest>(){

            @Override
            public ListMeshesRequest apply(RequestBuilderAndToken<ListMeshesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMeshesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMeshesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMeshesRequest, ListMeshesResponse>(){

            @Override
            public ListMeshesResponse apply(ListMeshesRequest request) {
                return ServiceMeshPaginators.this.client.listMeshes(request);
            }
        }, (Function)new Function<ListMeshesResponse, List<MeshSummary>>(){

            @Override
            public List<MeshSummary> apply(ListMeshesResponse response) {
                return response.getMeshCollection().getItems();
            }
        });
    }

    public Iterable<ListVirtualDeploymentsResponse> listVirtualDeploymentsResponseIterator(final ListVirtualDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVirtualDeploymentsRequest.Builder>(){

            @Override
            public ListVirtualDeploymentsRequest.Builder get() {
                return ListVirtualDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualDeploymentsResponse, String>(){

            @Override
            public String apply(ListVirtualDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualDeploymentsRequest.Builder>, ListVirtualDeploymentsRequest>(){

            @Override
            public ListVirtualDeploymentsRequest apply(RequestBuilderAndToken<ListVirtualDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualDeploymentsRequest, ListVirtualDeploymentsResponse>(){

            @Override
            public ListVirtualDeploymentsResponse apply(ListVirtualDeploymentsRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualDeployments(request);
            }
        });
    }

    public Iterable<VirtualDeploymentSummary> listVirtualDeploymentsRecordIterator(final ListVirtualDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVirtualDeploymentsRequest.Builder>(){

            @Override
            public ListVirtualDeploymentsRequest.Builder get() {
                return ListVirtualDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualDeploymentsResponse, String>(){

            @Override
            public String apply(ListVirtualDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualDeploymentsRequest.Builder>, ListVirtualDeploymentsRequest>(){

            @Override
            public ListVirtualDeploymentsRequest apply(RequestBuilderAndToken<ListVirtualDeploymentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualDeploymentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualDeploymentsRequest, ListVirtualDeploymentsResponse>(){

            @Override
            public ListVirtualDeploymentsResponse apply(ListVirtualDeploymentsRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualDeployments(request);
            }
        }, (Function)new Function<ListVirtualDeploymentsResponse, List<VirtualDeploymentSummary>>(){

            @Override
            public List<VirtualDeploymentSummary> apply(ListVirtualDeploymentsResponse response) {
                return response.getVirtualDeploymentCollection().getItems();
            }
        });
    }

    public Iterable<ListVirtualServiceRouteTablesResponse> listVirtualServiceRouteTablesResponseIterator(final ListVirtualServiceRouteTablesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVirtualServiceRouteTablesRequest.Builder>(){

            @Override
            public ListVirtualServiceRouteTablesRequest.Builder get() {
                return ListVirtualServiceRouteTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualServiceRouteTablesResponse, String>(){

            @Override
            public String apply(ListVirtualServiceRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualServiceRouteTablesRequest.Builder>, ListVirtualServiceRouteTablesRequest>(){

            @Override
            public ListVirtualServiceRouteTablesRequest apply(RequestBuilderAndToken<ListVirtualServiceRouteTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualServiceRouteTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualServiceRouteTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualServiceRouteTablesRequest, ListVirtualServiceRouteTablesResponse>(){

            @Override
            public ListVirtualServiceRouteTablesResponse apply(ListVirtualServiceRouteTablesRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualServiceRouteTables(request);
            }
        });
    }

    public Iterable<VirtualServiceRouteTableSummary> listVirtualServiceRouteTablesRecordIterator(final ListVirtualServiceRouteTablesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVirtualServiceRouteTablesRequest.Builder>(){

            @Override
            public ListVirtualServiceRouteTablesRequest.Builder get() {
                return ListVirtualServiceRouteTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualServiceRouteTablesResponse, String>(){

            @Override
            public String apply(ListVirtualServiceRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualServiceRouteTablesRequest.Builder>, ListVirtualServiceRouteTablesRequest>(){

            @Override
            public ListVirtualServiceRouteTablesRequest apply(RequestBuilderAndToken<ListVirtualServiceRouteTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualServiceRouteTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualServiceRouteTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualServiceRouteTablesRequest, ListVirtualServiceRouteTablesResponse>(){

            @Override
            public ListVirtualServiceRouteTablesResponse apply(ListVirtualServiceRouteTablesRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualServiceRouteTables(request);
            }
        }, (Function)new Function<ListVirtualServiceRouteTablesResponse, List<VirtualServiceRouteTableSummary>>(){

            @Override
            public List<VirtualServiceRouteTableSummary> apply(ListVirtualServiceRouteTablesResponse response) {
                return response.getVirtualServiceRouteTableCollection().getItems();
            }
        });
    }

    public Iterable<ListVirtualServicesResponse> listVirtualServicesResponseIterator(final ListVirtualServicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVirtualServicesRequest.Builder>(){

            @Override
            public ListVirtualServicesRequest.Builder get() {
                return ListVirtualServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualServicesResponse, String>(){

            @Override
            public String apply(ListVirtualServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualServicesRequest.Builder>, ListVirtualServicesRequest>(){

            @Override
            public ListVirtualServicesRequest apply(RequestBuilderAndToken<ListVirtualServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualServicesRequest, ListVirtualServicesResponse>(){

            @Override
            public ListVirtualServicesResponse apply(ListVirtualServicesRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualServices(request);
            }
        });
    }

    public Iterable<VirtualServiceSummary> listVirtualServicesRecordIterator(final ListVirtualServicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVirtualServicesRequest.Builder>(){

            @Override
            public ListVirtualServicesRequest.Builder get() {
                return ListVirtualServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualServicesResponse, String>(){

            @Override
            public String apply(ListVirtualServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualServicesRequest.Builder>, ListVirtualServicesRequest>(){

            @Override
            public ListVirtualServicesRequest apply(RequestBuilderAndToken<ListVirtualServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualServicesRequest, ListVirtualServicesResponse>(){

            @Override
            public ListVirtualServicesResponse apply(ListVirtualServicesRequest request) {
                return ServiceMeshPaginators.this.client.listVirtualServices(request);
            }
        }, (Function)new Function<ListVirtualServicesResponse, List<VirtualServiceSummary>>(){

            @Override
            public List<VirtualServiceSummary> apply(ListVirtualServicesResponse response) {
                return response.getVirtualServiceCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ServiceMeshPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

