/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListServiceEnvironmentsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String serviceEnvironmentId;
    private String serviceEnvironmentType;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String displayName;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getServiceEnvironmentId() {
        return this.serviceEnvironmentId;
    }

    public String getServiceEnvironmentType() {
        return this.serviceEnvironmentType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).serviceEnvironmentId(this.serviceEnvironmentId).serviceEnvironmentType(this.serviceEnvironmentType).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).displayName(this.displayName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",serviceEnvironmentId=").append(String.valueOf(this.serviceEnvironmentId));
        sb.append(",serviceEnvironmentType=").append(String.valueOf(this.serviceEnvironmentType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListServiceEnvironmentsRequest)) {
            return false;
        }
        ListServiceEnvironmentsRequest other = (ListServiceEnvironmentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.serviceEnvironmentId, other.serviceEnvironmentId) && Objects.equals(this.serviceEnvironmentType, other.serviceEnvironmentType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.displayName, other.displayName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.serviceEnvironmentId == null ? 43 : this.serviceEnvironmentId.hashCode());
        result = result * 59 + (this.serviceEnvironmentType == null ? 43 : this.serviceEnvironmentType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListServiceEnvironmentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String serviceEnvironmentId = null;
        private String serviceEnvironmentType = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String displayName = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder serviceEnvironmentId(String serviceEnvironmentId) {
            this.serviceEnvironmentId = serviceEnvironmentId;
            return this;
        }

        public Builder serviceEnvironmentType(String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListServiceEnvironmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.serviceEnvironmentId(o.getServiceEnvironmentId());
            this.serviceEnvironmentType(o.getServiceEnvironmentType());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.displayName(o.getDisplayName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListServiceEnvironmentsRequest build() {
            ListServiceEnvironmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListServiceEnvironmentsRequest buildWithoutInvocationCallback() {
            ListServiceEnvironmentsRequest request = new ListServiceEnvironmentsRequest();
            request.compartmentId = this.compartmentId;
            request.serviceEnvironmentId = this.serviceEnvironmentId;
            request.serviceEnvironmentType = this.serviceEnvironmentType;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.displayName = this.displayName;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Id("ID");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

