/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicemanagerproxy.model.ServiceDefinition;
import com.oracle.bmc.servicemanagerproxy.model.ServiceEntitlementRegistrationStatus;
import com.oracle.bmc.servicemanagerproxy.model.ServiceEnvironmentEndPointOverview;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceEnvironmentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="status")
    private final ServiceEntitlementRegistrationStatus status;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="serviceDefinition")
    private final ServiceDefinition serviceDefinition;
    @JsonProperty(value="consoleUrl")
    private final String consoleUrl;
    @JsonProperty(value="serviceEnvironmentEndpoints")
    private final List<ServiceEnvironmentEndPointOverview> serviceEnvironmentEndpoints;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"id", "subscriptionId", "status", "compartmentId", "serviceDefinition", "consoleUrl", "serviceEnvironmentEndpoints", "definedTags", "freeformTags"})
    public ServiceEnvironmentSummary(String id, String subscriptionId, ServiceEntitlementRegistrationStatus status, String compartmentId, ServiceDefinition serviceDefinition, String consoleUrl, List<ServiceEnvironmentEndPointOverview> serviceEnvironmentEndpoints, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags) {
        this.id = id;
        this.subscriptionId = subscriptionId;
        this.status = status;
        this.compartmentId = compartmentId;
        this.serviceDefinition = serviceDefinition;
        this.consoleUrl = consoleUrl;
        this.serviceEnvironmentEndpoints = serviceEnvironmentEndpoints;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public ServiceEntitlementRegistrationStatus getStatus() {
        return this.status;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public List<ServiceEnvironmentEndPointOverview> getServiceEnvironmentEndpoints() {
        return this.serviceEnvironmentEndpoints;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceEnvironmentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", serviceDefinition=").append(String.valueOf((Object)this.serviceDefinition));
        sb.append(", consoleUrl=").append(String.valueOf(this.consoleUrl));
        sb.append(", serviceEnvironmentEndpoints=").append(String.valueOf(this.serviceEnvironmentEndpoints));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceEnvironmentSummary)) {
            return false;
        }
        ServiceEnvironmentSummary other = (ServiceEnvironmentSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.serviceDefinition, (Object)other.serviceDefinition) && Objects.equals(this.consoleUrl, other.consoleUrl) && Objects.equals(this.serviceEnvironmentEndpoints, other.serviceEnvironmentEndpoints) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.serviceDefinition == null ? 43 : this.serviceDefinition.hashCode());
        result = result * 59 + (this.consoleUrl == null ? 43 : this.consoleUrl.hashCode());
        result = result * 59 + (this.serviceEnvironmentEndpoints == null ? 43 : this.serviceEnvironmentEndpoints.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="status")
        private ServiceEntitlementRegistrationStatus status;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="serviceDefinition")
        private ServiceDefinition serviceDefinition;
        @JsonProperty(value="consoleUrl")
        private String consoleUrl;
        @JsonProperty(value="serviceEnvironmentEndpoints")
        private List<ServiceEnvironmentEndPointOverview> serviceEnvironmentEndpoints;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder status(ServiceEntitlementRegistrationStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder serviceDefinition(ServiceDefinition serviceDefinition) {
            this.serviceDefinition = serviceDefinition;
            this.__explicitlySet__.add("serviceDefinition");
            return this;
        }

        public Builder consoleUrl(String consoleUrl) {
            this.consoleUrl = consoleUrl;
            this.__explicitlySet__.add("consoleUrl");
            return this;
        }

        public Builder serviceEnvironmentEndpoints(List<ServiceEnvironmentEndPointOverview> serviceEnvironmentEndpoints) {
            this.serviceEnvironmentEndpoints = serviceEnvironmentEndpoints;
            this.__explicitlySet__.add("serviceEnvironmentEndpoints");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public ServiceEnvironmentSummary build() {
            ServiceEnvironmentSummary model = new ServiceEnvironmentSummary(this.id, this.subscriptionId, this.status, this.compartmentId, this.serviceDefinition, this.consoleUrl, this.serviceEnvironmentEndpoints, this.definedTags, this.freeformTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceEnvironmentSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("serviceDefinition")) {
                this.serviceDefinition(model.getServiceDefinition());
            }
            if (model.wasPropertyExplicitlySet("consoleUrl")) {
                this.consoleUrl(model.getConsoleUrl());
            }
            if (model.wasPropertyExplicitlySet("serviceEnvironmentEndpoints")) {
                this.serviceEnvironmentEndpoints(model.getServiceEnvironmentEndpoints());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            return this;
        }
    }
}

