/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.secrets.Secrets;
import com.oracle.bmc.secrets.model.SecretBundleVersionSummary;
import com.oracle.bmc.secrets.requests.ListSecretBundleVersionsRequest;
import com.oracle.bmc.secrets.responses.ListSecretBundleVersionsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SecretsPaginators {
    private final Secrets client;

    public SecretsPaginators(Secrets client) {
        this.client = client;
    }

    public Iterable<ListSecretBundleVersionsResponse> listSecretBundleVersionsResponseIterator(final ListSecretBundleVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretBundleVersionsRequest.Builder>(){

            @Override
            public ListSecretBundleVersionsRequest.Builder get() {
                return ListSecretBundleVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, String>(){

            @Override
            public String apply(ListSecretBundleVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder>, ListSecretBundleVersionsRequest>(){

            @Override
            public ListSecretBundleVersionsRequest apply(RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretBundleVersionsRequest, ListSecretBundleVersionsResponse>(){

            @Override
            public ListSecretBundleVersionsResponse apply(ListSecretBundleVersionsRequest request) {
                return SecretsPaginators.this.client.listSecretBundleVersions(request);
            }
        });
    }

    public Iterable<SecretBundleVersionSummary> listSecretBundleVersionsRecordIterator(final ListSecretBundleVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretBundleVersionsRequest.Builder>(){

            @Override
            public ListSecretBundleVersionsRequest.Builder get() {
                return ListSecretBundleVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, String>(){

            @Override
            public String apply(ListSecretBundleVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder>, ListSecretBundleVersionsRequest>(){

            @Override
            public ListSecretBundleVersionsRequest apply(RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretBundleVersionsRequest, ListSecretBundleVersionsResponse>(){

            @Override
            public ListSecretBundleVersionsResponse apply(ListSecretBundleVersionsRequest request) {
                return SecretsPaginators.this.client.listSecretBundleVersions(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, List<SecretBundleVersionSummary>>(){

            @Override
            public List<SecretBundleVersionSummary> apply(ListSecretBundleVersionsResponse response) {
                return response.getItems();
            }
        });
    }
}

