/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.sch.model.TargetDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class ObjectStorageTargetDetails
extends TargetDetails {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="objectNamePrefix")
    private final String objectNamePrefix;
    @JsonProperty(value="batchRolloverSizeInMBs")
    private final Integer batchRolloverSizeInMBs;
    @JsonProperty(value="batchRolloverTimeInMs")
    private final Integer batchRolloverTimeInMs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ObjectStorageTargetDetails(String namespace, String bucketName, String objectNamePrefix, Integer batchRolloverSizeInMBs, Integer batchRolloverTimeInMs) {
        this.namespace = namespace;
        this.bucketName = bucketName;
        this.objectNamePrefix = objectNamePrefix;
        this.batchRolloverSizeInMBs = batchRolloverSizeInMBs;
        this.batchRolloverTimeInMs = batchRolloverTimeInMs;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectNamePrefix() {
        return this.objectNamePrefix;
    }

    public Integer getBatchRolloverSizeInMBs() {
        return this.batchRolloverSizeInMBs;
    }

    public Integer getBatchRolloverTimeInMs() {
        return this.batchRolloverTimeInMs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectStorageTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", objectNamePrefix=").append(String.valueOf(this.objectNamePrefix));
        sb.append(", batchRolloverSizeInMBs=").append(String.valueOf(this.batchRolloverSizeInMBs));
        sb.append(", batchRolloverTimeInMs=").append(String.valueOf(this.batchRolloverTimeInMs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectStorageTargetDetails)) {
            return false;
        }
        ObjectStorageTargetDetails other = (ObjectStorageTargetDetails)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectNamePrefix, other.objectNamePrefix) && Objects.equals(this.batchRolloverSizeInMBs, other.batchRolloverSizeInMBs) && Objects.equals(this.batchRolloverTimeInMs, other.batchRolloverTimeInMs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectNamePrefix == null ? 43 : this.objectNamePrefix.hashCode());
        result = result * 59 + (this.batchRolloverSizeInMBs == null ? 43 : this.batchRolloverSizeInMBs.hashCode());
        result = result * 59 + (this.batchRolloverTimeInMs == null ? 43 : this.batchRolloverTimeInMs.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="objectNamePrefix")
        private String objectNamePrefix;
        @JsonProperty(value="batchRolloverSizeInMBs")
        private Integer batchRolloverSizeInMBs;
        @JsonProperty(value="batchRolloverTimeInMs")
        private Integer batchRolloverTimeInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder objectNamePrefix(String objectNamePrefix) {
            this.objectNamePrefix = objectNamePrefix;
            this.__explicitlySet__.add("objectNamePrefix");
            return this;
        }

        public Builder batchRolloverSizeInMBs(Integer batchRolloverSizeInMBs) {
            this.batchRolloverSizeInMBs = batchRolloverSizeInMBs;
            this.__explicitlySet__.add("batchRolloverSizeInMBs");
            return this;
        }

        public Builder batchRolloverTimeInMs(Integer batchRolloverTimeInMs) {
            this.batchRolloverTimeInMs = batchRolloverTimeInMs;
            this.__explicitlySet__.add("batchRolloverTimeInMs");
            return this;
        }

        public ObjectStorageTargetDetails build() {
            ObjectStorageTargetDetails model = new ObjectStorageTargetDetails(this.namespace, this.bucketName, this.objectNamePrefix, this.batchRolloverSizeInMBs, this.batchRolloverTimeInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectStorageTargetDetails model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("objectNamePrefix")) {
                this.objectNamePrefix(model.getObjectNamePrefix());
            }
            if (model.wasPropertyExplicitlySet("batchRolloverSizeInMBs")) {
                this.batchRolloverSizeInMBs(model.getBatchRolloverSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("batchRolloverTimeInMs")) {
                this.batchRolloverTimeInMs(model.getBatchRolloverTimeInMs());
            }
            return this;
        }
    }
}

