/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.sch.model.DimensionDetails;
import com.oracle.bmc.sch.model.TargetDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class MonitoringTargetDetails
extends TargetDetails {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="metricNamespace")
    private final String metricNamespace;
    @JsonProperty(value="metric")
    private final String metric;
    @JsonProperty(value="dimensions")
    private final List<DimensionDetails> dimensions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MonitoringTargetDetails(String compartmentId, String metricNamespace, String metric, List<DimensionDetails> dimensions) {
        this.compartmentId = compartmentId;
        this.metricNamespace = metricNamespace;
        this.metric = metric;
        this.dimensions = dimensions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getMetricNamespace() {
        return this.metricNamespace;
    }

    public String getMetric() {
        return this.metric;
    }

    public List<DimensionDetails> getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitoringTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", metricNamespace=").append(String.valueOf(this.metricNamespace));
        sb.append(", metric=").append(String.valueOf(this.metric));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoringTargetDetails)) {
            return false;
        }
        MonitoringTargetDetails other = (MonitoringTargetDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.metricNamespace, other.metricNamespace) && Objects.equals(this.metric, other.metric) && Objects.equals(this.dimensions, other.dimensions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.metricNamespace == null ? 43 : this.metricNamespace.hashCode());
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="metricNamespace")
        private String metricNamespace;
        @JsonProperty(value="metric")
        private String metric;
        @JsonProperty(value="dimensions")
        private List<DimensionDetails> dimensions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            this.__explicitlySet__.add("metricNamespace");
            return this;
        }

        public Builder metric(String metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public Builder dimensions(List<DimensionDetails> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public MonitoringTargetDetails build() {
            MonitoringTargetDetails model = new MonitoringTargetDetails(this.compartmentId, this.metricNamespace, this.metric, this.dimensions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitoringTargetDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("metricNamespace")) {
                this.metricNamespace(model.getMetricNamespace());
            }
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            return this;
        }
    }
}

