/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.rover.model.EnclosureType;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.model.RoverWorkload;
import com.oracle.bmc.rover.model.ShippingAddress;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateRoverClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="clusterSize")
    private final Integer clusterSize;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="clusterWorkloads")
    private final List<RoverWorkload> clusterWorkloads;
    @JsonProperty(value="superUserPassword")
    private final String superUserPassword;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="unlockPassphrase")
    private final String unlockPassphrase;
    @JsonProperty(value="enclosureType")
    private final EnclosureType enclosureType;
    @JsonProperty(value="pointOfContact")
    private final String pointOfContact;
    @JsonProperty(value="pointOfContactPhoneNumber")
    private final String pointOfContactPhoneNumber;
    @JsonProperty(value="shippingPreference")
    private final ShippingPreference shippingPreference;
    @JsonProperty(value="oracleShippingTrackingUrl")
    private final String oracleShippingTrackingUrl;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="shippingVendor")
    private final String shippingVendor;
    @JsonProperty(value="timePickupExpected")
    private final Date timePickupExpected;
    @JsonProperty(value="isImportRequested")
    private final Boolean isImportRequested;
    @JsonProperty(value="importCompartmentId")
    private final String importCompartmentId;
    @JsonProperty(value="importFileBucket")
    private final String importFileBucket;
    @JsonProperty(value="dataValidationCode")
    private final String dataValidationCode;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "clusterSize", "customerShippingAddress", "clusterWorkloads", "superUserPassword", "lifecycleState", "lifecycleStateDetails", "unlockPassphrase", "enclosureType", "pointOfContact", "pointOfContactPhoneNumber", "shippingPreference", "oracleShippingTrackingUrl", "subscriptionId", "shippingVendor", "timePickupExpected", "isImportRequested", "importCompartmentId", "importFileBucket", "dataValidationCode", "freeformTags", "definedTags", "systemTags"})
    public UpdateRoverClusterDetails(String displayName, Integer clusterSize, ShippingAddress customerShippingAddress, List<RoverWorkload> clusterWorkloads, String superUserPassword, LifecycleState lifecycleState, String lifecycleStateDetails, String unlockPassphrase, EnclosureType enclosureType, String pointOfContact, String pointOfContactPhoneNumber, ShippingPreference shippingPreference, String oracleShippingTrackingUrl, String subscriptionId, String shippingVendor, Date timePickupExpected, Boolean isImportRequested, String importCompartmentId, String importFileBucket, String dataValidationCode, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.displayName = displayName;
        this.clusterSize = clusterSize;
        this.customerShippingAddress = customerShippingAddress;
        this.clusterWorkloads = clusterWorkloads;
        this.superUserPassword = superUserPassword;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.unlockPassphrase = unlockPassphrase;
        this.enclosureType = enclosureType;
        this.pointOfContact = pointOfContact;
        this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
        this.shippingPreference = shippingPreference;
        this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
        this.subscriptionId = subscriptionId;
        this.shippingVendor = shippingVendor;
        this.timePickupExpected = timePickupExpected;
        this.isImportRequested = isImportRequested;
        this.importCompartmentId = importCompartmentId;
        this.importFileBucket = importFileBucket;
        this.dataValidationCode = dataValidationCode;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getClusterSize() {
        return this.clusterSize;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public List<RoverWorkload> getClusterWorkloads() {
        return this.clusterWorkloads;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public String getUnlockPassphrase() {
        return this.unlockPassphrase;
    }

    public EnclosureType getEnclosureType() {
        return this.enclosureType;
    }

    public String getPointOfContact() {
        return this.pointOfContact;
    }

    public String getPointOfContactPhoneNumber() {
        return this.pointOfContactPhoneNumber;
    }

    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    public String getOracleShippingTrackingUrl() {
        return this.oracleShippingTrackingUrl;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getShippingVendor() {
        return this.shippingVendor;
    }

    public Date getTimePickupExpected() {
        return this.timePickupExpected;
    }

    public Boolean getIsImportRequested() {
        return this.isImportRequested;
    }

    public String getImportCompartmentId() {
        return this.importCompartmentId;
    }

    public String getImportFileBucket() {
        return this.importFileBucket;
    }

    public String getDataValidationCode() {
        return this.dataValidationCode;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateRoverClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", clusterSize=").append(String.valueOf(this.clusterSize));
        sb.append(", customerShippingAddress=").append(String.valueOf((Object)this.customerShippingAddress));
        sb.append(", clusterWorkloads=").append(String.valueOf(this.clusterWorkloads));
        sb.append(", superUserPassword=").append(String.valueOf(this.superUserPassword));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", unlockPassphrase=").append(String.valueOf(this.unlockPassphrase));
        sb.append(", enclosureType=").append(String.valueOf((Object)this.enclosureType));
        sb.append(", pointOfContact=").append(String.valueOf(this.pointOfContact));
        sb.append(", pointOfContactPhoneNumber=").append(String.valueOf(this.pointOfContactPhoneNumber));
        sb.append(", shippingPreference=").append(String.valueOf((Object)this.shippingPreference));
        sb.append(", oracleShippingTrackingUrl=").append(String.valueOf(this.oracleShippingTrackingUrl));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", shippingVendor=").append(String.valueOf(this.shippingVendor));
        sb.append(", timePickupExpected=").append(String.valueOf(this.timePickupExpected));
        sb.append(", isImportRequested=").append(String.valueOf(this.isImportRequested));
        sb.append(", importCompartmentId=").append(String.valueOf(this.importCompartmentId));
        sb.append(", importFileBucket=").append(String.valueOf(this.importFileBucket));
        sb.append(", dataValidationCode=").append(String.valueOf(this.dataValidationCode));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRoverClusterDetails)) {
            return false;
        }
        UpdateRoverClusterDetails other = (UpdateRoverClusterDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.clusterSize, other.clusterSize) && Objects.equals((Object)this.customerShippingAddress, (Object)other.customerShippingAddress) && Objects.equals(this.clusterWorkloads, other.clusterWorkloads) && Objects.equals(this.superUserPassword, other.superUserPassword) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals(this.unlockPassphrase, other.unlockPassphrase) && Objects.equals((Object)this.enclosureType, (Object)other.enclosureType) && Objects.equals(this.pointOfContact, other.pointOfContact) && Objects.equals(this.pointOfContactPhoneNumber, other.pointOfContactPhoneNumber) && Objects.equals((Object)this.shippingPreference, (Object)other.shippingPreference) && Objects.equals(this.oracleShippingTrackingUrl, other.oracleShippingTrackingUrl) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.shippingVendor, other.shippingVendor) && Objects.equals(this.timePickupExpected, other.timePickupExpected) && Objects.equals(this.isImportRequested, other.isImportRequested) && Objects.equals(this.importCompartmentId, other.importCompartmentId) && Objects.equals(this.importFileBucket, other.importFileBucket) && Objects.equals(this.dataValidationCode, other.dataValidationCode) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.clusterSize == null ? 43 : this.clusterSize.hashCode());
        result = result * 59 + (this.customerShippingAddress == null ? 43 : this.customerShippingAddress.hashCode());
        result = result * 59 + (this.clusterWorkloads == null ? 43 : this.clusterWorkloads.hashCode());
        result = result * 59 + (this.superUserPassword == null ? 43 : this.superUserPassword.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.unlockPassphrase == null ? 43 : this.unlockPassphrase.hashCode());
        result = result * 59 + (this.enclosureType == null ? 43 : this.enclosureType.hashCode());
        result = result * 59 + (this.pointOfContact == null ? 43 : this.pointOfContact.hashCode());
        result = result * 59 + (this.pointOfContactPhoneNumber == null ? 43 : this.pointOfContactPhoneNumber.hashCode());
        result = result * 59 + (this.shippingPreference == null ? 43 : this.shippingPreference.hashCode());
        result = result * 59 + (this.oracleShippingTrackingUrl == null ? 43 : this.oracleShippingTrackingUrl.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.shippingVendor == null ? 43 : this.shippingVendor.hashCode());
        result = result * 59 + (this.timePickupExpected == null ? 43 : this.timePickupExpected.hashCode());
        result = result * 59 + (this.isImportRequested == null ? 43 : this.isImportRequested.hashCode());
        result = result * 59 + (this.importCompartmentId == null ? 43 : this.importCompartmentId.hashCode());
        result = result * 59 + (this.importFileBucket == null ? 43 : this.importFileBucket.hashCode());
        result = result * 59 + (this.dataValidationCode == null ? 43 : this.dataValidationCode.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ShippingPreference implements BmcEnum
    {
        OracleShipped("ORACLE_SHIPPED"),
        CustomerPickup("CUSTOMER_PICKUP");

        private final String value;
        private static Map<String, ShippingPreference> map;

        private ShippingPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShippingPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ShippingPreference: " + key);
        }

        static {
            map = new HashMap<String, ShippingPreference>();
            for (ShippingPreference v : ShippingPreference.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="clusterSize")
        private Integer clusterSize;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="clusterWorkloads")
        private List<RoverWorkload> clusterWorkloads;
        @JsonProperty(value="superUserPassword")
        private String superUserPassword;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="unlockPassphrase")
        private String unlockPassphrase;
        @JsonProperty(value="enclosureType")
        private EnclosureType enclosureType;
        @JsonProperty(value="pointOfContact")
        private String pointOfContact;
        @JsonProperty(value="pointOfContactPhoneNumber")
        private String pointOfContactPhoneNumber;
        @JsonProperty(value="shippingPreference")
        private ShippingPreference shippingPreference;
        @JsonProperty(value="oracleShippingTrackingUrl")
        private String oracleShippingTrackingUrl;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="shippingVendor")
        private String shippingVendor;
        @JsonProperty(value="timePickupExpected")
        private Date timePickupExpected;
        @JsonProperty(value="isImportRequested")
        private Boolean isImportRequested;
        @JsonProperty(value="importCompartmentId")
        private String importCompartmentId;
        @JsonProperty(value="importFileBucket")
        private String importFileBucket;
        @JsonProperty(value="dataValidationCode")
        private String dataValidationCode;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder clusterSize(Integer clusterSize) {
            this.clusterSize = clusterSize;
            this.__explicitlySet__.add("clusterSize");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder clusterWorkloads(List<RoverWorkload> clusterWorkloads) {
            this.clusterWorkloads = clusterWorkloads;
            this.__explicitlySet__.add("clusterWorkloads");
            return this;
        }

        public Builder superUserPassword(String superUserPassword) {
            this.superUserPassword = superUserPassword;
            this.__explicitlySet__.add("superUserPassword");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder unlockPassphrase(String unlockPassphrase) {
            this.unlockPassphrase = unlockPassphrase;
            this.__explicitlySet__.add("unlockPassphrase");
            return this;
        }

        public Builder enclosureType(EnclosureType enclosureType) {
            this.enclosureType = enclosureType;
            this.__explicitlySet__.add("enclosureType");
            return this;
        }

        public Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = pointOfContact;
            this.__explicitlySet__.add("pointOfContact");
            return this;
        }

        public Builder pointOfContactPhoneNumber(String pointOfContactPhoneNumber) {
            this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
            this.__explicitlySet__.add("pointOfContactPhoneNumber");
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            this.__explicitlySet__.add("shippingPreference");
            return this;
        }

        public Builder oracleShippingTrackingUrl(String oracleShippingTrackingUrl) {
            this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
            this.__explicitlySet__.add("oracleShippingTrackingUrl");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder shippingVendor(String shippingVendor) {
            this.shippingVendor = shippingVendor;
            this.__explicitlySet__.add("shippingVendor");
            return this;
        }

        public Builder timePickupExpected(Date timePickupExpected) {
            this.timePickupExpected = timePickupExpected;
            this.__explicitlySet__.add("timePickupExpected");
            return this;
        }

        public Builder isImportRequested(Boolean isImportRequested) {
            this.isImportRequested = isImportRequested;
            this.__explicitlySet__.add("isImportRequested");
            return this;
        }

        public Builder importCompartmentId(String importCompartmentId) {
            this.importCompartmentId = importCompartmentId;
            this.__explicitlySet__.add("importCompartmentId");
            return this;
        }

        public Builder importFileBucket(String importFileBucket) {
            this.importFileBucket = importFileBucket;
            this.__explicitlySet__.add("importFileBucket");
            return this;
        }

        public Builder dataValidationCode(String dataValidationCode) {
            this.dataValidationCode = dataValidationCode;
            this.__explicitlySet__.add("dataValidationCode");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public UpdateRoverClusterDetails build() {
            UpdateRoverClusterDetails model = new UpdateRoverClusterDetails(this.displayName, this.clusterSize, this.customerShippingAddress, this.clusterWorkloads, this.superUserPassword, this.lifecycleState, this.lifecycleStateDetails, this.unlockPassphrase, this.enclosureType, this.pointOfContact, this.pointOfContactPhoneNumber, this.shippingPreference, this.oracleShippingTrackingUrl, this.subscriptionId, this.shippingVendor, this.timePickupExpected, this.isImportRequested, this.importCompartmentId, this.importFileBucket, this.dataValidationCode, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateRoverClusterDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("clusterSize")) {
                this.clusterSize(model.getClusterSize());
            }
            if (model.wasPropertyExplicitlySet("customerShippingAddress")) {
                this.customerShippingAddress(model.getCustomerShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("clusterWorkloads")) {
                this.clusterWorkloads(model.getClusterWorkloads());
            }
            if (model.wasPropertyExplicitlySet("superUserPassword")) {
                this.superUserPassword(model.getSuperUserPassword());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("unlockPassphrase")) {
                this.unlockPassphrase(model.getUnlockPassphrase());
            }
            if (model.wasPropertyExplicitlySet("enclosureType")) {
                this.enclosureType(model.getEnclosureType());
            }
            if (model.wasPropertyExplicitlySet("pointOfContact")) {
                this.pointOfContact(model.getPointOfContact());
            }
            if (model.wasPropertyExplicitlySet("pointOfContactPhoneNumber")) {
                this.pointOfContactPhoneNumber(model.getPointOfContactPhoneNumber());
            }
            if (model.wasPropertyExplicitlySet("shippingPreference")) {
                this.shippingPreference(model.getShippingPreference());
            }
            if (model.wasPropertyExplicitlySet("oracleShippingTrackingUrl")) {
                this.oracleShippingTrackingUrl(model.getOracleShippingTrackingUrl());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("shippingVendor")) {
                this.shippingVendor(model.getShippingVendor());
            }
            if (model.wasPropertyExplicitlySet("timePickupExpected")) {
                this.timePickupExpected(model.getTimePickupExpected());
            }
            if (model.wasPropertyExplicitlySet("isImportRequested")) {
                this.isImportRequested(model.getIsImportRequested());
            }
            if (model.wasPropertyExplicitlySet("importCompartmentId")) {
                this.importCompartmentId(model.getImportCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("importFileBucket")) {
                this.importFileBucket(model.getImportFileBucket());
            }
            if (model.wasPropertyExplicitlySet("dataValidationCode")) {
                this.dataValidationCode(model.getDataValidationCode());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

