/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShippingAddress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="addressee")
    private final String addressee;
    @JsonProperty(value="careOf")
    private final String careOf;
    @JsonProperty(value="address1")
    private final String address1;
    @JsonProperty(value="address2")
    private final String address2;
    @JsonProperty(value="address3")
    private final String address3;
    @JsonProperty(value="address4")
    private final String address4;
    @JsonProperty(value="cityOrLocality")
    private final String cityOrLocality;
    @JsonProperty(value="stateOrRegion")
    private final String stateOrRegion;
    @JsonProperty(value="zipcode")
    private final String zipcode;
    @JsonProperty(value="country")
    private final String country;
    @JsonProperty(value="phoneNumber")
    private final String phoneNumber;
    @JsonProperty(value="email")
    private final String email;

    @Deprecated
    @ConstructorProperties(value={"addressee", "careOf", "address1", "address2", "address3", "address4", "cityOrLocality", "stateOrRegion", "zipcode", "country", "phoneNumber", "email"})
    public ShippingAddress(String addressee, String careOf, String address1, String address2, String address3, String address4, String cityOrLocality, String stateOrRegion, String zipcode, String country, String phoneNumber, String email) {
        this.addressee = addressee;
        this.careOf = careOf;
        this.address1 = address1;
        this.address2 = address2;
        this.address3 = address3;
        this.address4 = address4;
        this.cityOrLocality = cityOrLocality;
        this.stateOrRegion = stateOrRegion;
        this.zipcode = zipcode;
        this.country = country;
        this.phoneNumber = phoneNumber;
        this.email = email;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddressee() {
        return this.addressee;
    }

    public String getCareOf() {
        return this.careOf;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getAddress3() {
        return this.address3;
    }

    public String getAddress4() {
        return this.address4;
    }

    public String getCityOrLocality() {
        return this.cityOrLocality;
    }

    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShippingAddress(");
        sb.append("super=").append(super.toString());
        sb.append("addressee=").append(String.valueOf(this.addressee));
        sb.append(", careOf=").append(String.valueOf(this.careOf));
        sb.append(", address1=").append(String.valueOf(this.address1));
        sb.append(", address2=").append(String.valueOf(this.address2));
        sb.append(", address3=").append(String.valueOf(this.address3));
        sb.append(", address4=").append(String.valueOf(this.address4));
        sb.append(", cityOrLocality=").append(String.valueOf(this.cityOrLocality));
        sb.append(", stateOrRegion=").append(String.valueOf(this.stateOrRegion));
        sb.append(", zipcode=").append(String.valueOf(this.zipcode));
        sb.append(", country=").append(String.valueOf(this.country));
        sb.append(", phoneNumber=").append(String.valueOf(this.phoneNumber));
        sb.append(", email=").append(String.valueOf(this.email));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShippingAddress)) {
            return false;
        }
        ShippingAddress other = (ShippingAddress)((Object)o);
        return Objects.equals(this.addressee, other.addressee) && Objects.equals(this.careOf, other.careOf) && Objects.equals(this.address1, other.address1) && Objects.equals(this.address2, other.address2) && Objects.equals(this.address3, other.address3) && Objects.equals(this.address4, other.address4) && Objects.equals(this.cityOrLocality, other.cityOrLocality) && Objects.equals(this.stateOrRegion, other.stateOrRegion) && Objects.equals(this.zipcode, other.zipcode) && Objects.equals(this.country, other.country) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.email, other.email) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.addressee == null ? 43 : this.addressee.hashCode());
        result = result * 59 + (this.careOf == null ? 43 : this.careOf.hashCode());
        result = result * 59 + (this.address1 == null ? 43 : this.address1.hashCode());
        result = result * 59 + (this.address2 == null ? 43 : this.address2.hashCode());
        result = result * 59 + (this.address3 == null ? 43 : this.address3.hashCode());
        result = result * 59 + (this.address4 == null ? 43 : this.address4.hashCode());
        result = result * 59 + (this.cityOrLocality == null ? 43 : this.cityOrLocality.hashCode());
        result = result * 59 + (this.stateOrRegion == null ? 43 : this.stateOrRegion.hashCode());
        result = result * 59 + (this.zipcode == null ? 43 : this.zipcode.hashCode());
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.phoneNumber == null ? 43 : this.phoneNumber.hashCode());
        result = result * 59 + (this.email == null ? 43 : this.email.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="addressee")
        private String addressee;
        @JsonProperty(value="careOf")
        private String careOf;
        @JsonProperty(value="address1")
        private String address1;
        @JsonProperty(value="address2")
        private String address2;
        @JsonProperty(value="address3")
        private String address3;
        @JsonProperty(value="address4")
        private String address4;
        @JsonProperty(value="cityOrLocality")
        private String cityOrLocality;
        @JsonProperty(value="stateOrRegion")
        private String stateOrRegion;
        @JsonProperty(value="zipcode")
        private String zipcode;
        @JsonProperty(value="country")
        private String country;
        @JsonProperty(value="phoneNumber")
        private String phoneNumber;
        @JsonProperty(value="email")
        private String email;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder addressee(String addressee) {
            this.addressee = addressee;
            this.__explicitlySet__.add("addressee");
            return this;
        }

        public Builder careOf(String careOf) {
            this.careOf = careOf;
            this.__explicitlySet__.add("careOf");
            return this;
        }

        public Builder address1(String address1) {
            this.address1 = address1;
            this.__explicitlySet__.add("address1");
            return this;
        }

        public Builder address2(String address2) {
            this.address2 = address2;
            this.__explicitlySet__.add("address2");
            return this;
        }

        public Builder address3(String address3) {
            this.address3 = address3;
            this.__explicitlySet__.add("address3");
            return this;
        }

        public Builder address4(String address4) {
            this.address4 = address4;
            this.__explicitlySet__.add("address4");
            return this;
        }

        public Builder cityOrLocality(String cityOrLocality) {
            this.cityOrLocality = cityOrLocality;
            this.__explicitlySet__.add("cityOrLocality");
            return this;
        }

        public Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            this.__explicitlySet__.add("stateOrRegion");
            return this;
        }

        public Builder zipcode(String zipcode) {
            this.zipcode = zipcode;
            this.__explicitlySet__.add("zipcode");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.__explicitlySet__.add("country");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.__explicitlySet__.add("phoneNumber");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.__explicitlySet__.add("email");
            return this;
        }

        public ShippingAddress build() {
            ShippingAddress model = new ShippingAddress(this.addressee, this.careOf, this.address1, this.address2, this.address3, this.address4, this.cityOrLocality, this.stateOrRegion, this.zipcode, this.country, this.phoneNumber, this.email);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShippingAddress model) {
            if (model.wasPropertyExplicitlySet("addressee")) {
                this.addressee(model.getAddressee());
            }
            if (model.wasPropertyExplicitlySet("careOf")) {
                this.careOf(model.getCareOf());
            }
            if (model.wasPropertyExplicitlySet("address1")) {
                this.address1(model.getAddress1());
            }
            if (model.wasPropertyExplicitlySet("address2")) {
                this.address2(model.getAddress2());
            }
            if (model.wasPropertyExplicitlySet("address3")) {
                this.address3(model.getAddress3());
            }
            if (model.wasPropertyExplicitlySet("address4")) {
                this.address4(model.getAddress4());
            }
            if (model.wasPropertyExplicitlySet("cityOrLocality")) {
                this.cityOrLocality(model.getCityOrLocality());
            }
            if (model.wasPropertyExplicitlySet("stateOrRegion")) {
                this.stateOrRegion(model.getStateOrRegion());
            }
            if (model.wasPropertyExplicitlySet("zipcode")) {
                this.zipcode(model.getZipcode());
            }
            if (model.wasPropertyExplicitlySet("country")) {
                this.country(model.getCountry());
            }
            if (model.wasPropertyExplicitlySet("phoneNumber")) {
                this.phoneNumber(model.getPhoneNumber());
            }
            if (model.wasPropertyExplicitlySet("email")) {
                this.email(model.getEmail());
            }
            return this;
        }
    }
}

