/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.Shape;
import com.oracle.bmc.rover.model.ShapeSummary;
import com.oracle.bmc.rover.requests.ListShapesRequest;
import com.oracle.bmc.rover.responses.ListShapesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ShapePaginators {
    private final Shape client;

    public ShapePaginators(Shape client) {
        this.client = client;
    }

    public Iterable<ListShapesResponse> listShapesResponseIterator(final ListShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            @Override
            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            @Override
            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            @Override
            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            @Override
            public ListShapesResponse apply(ListShapesRequest request) {
                return ShapePaginators.this.client.listShapes(request);
            }
        });
    }

    public Iterable<ShapeSummary> listShapesRecordIterator(final ListShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            @Override
            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            @Override
            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            @Override
            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            @Override
            public ListShapesResponse apply(ListShapesRequest request) {
                return ShapePaginators.this.client.listShapes(request);
            }
        }, (Function)new Function<ListShapesResponse, List<ShapeSummary>>(){

            @Override
            public List<ShapeSummary> apply(ListShapesResponse response) {
                return response.getShapeCollection().getItems();
            }
        });
    }
}

