/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverCluster;
import com.oracle.bmc.rover.model.RoverClusterSummary;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RoverClusterPaginators {
    private final RoverCluster client;

    public RoverClusterPaginators(RoverCluster client) {
        this.client = client;
    }

    public Iterable<ListRoverClustersResponse> listRoverClustersResponseIterator(final ListRoverClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverClustersRequest.Builder>(){

            @Override
            public ListRoverClustersRequest.Builder get() {
                return ListRoverClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, String>(){

            @Override
            public String apply(ListRoverClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverClustersRequest.Builder>, ListRoverClustersRequest>(){

            @Override
            public ListRoverClustersRequest apply(RequestBuilderAndToken<ListRoverClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverClustersRequest, ListRoverClustersResponse>(){

            @Override
            public ListRoverClustersResponse apply(ListRoverClustersRequest request) {
                return RoverClusterPaginators.this.client.listRoverClusters(request);
            }
        });
    }

    public Iterable<RoverClusterSummary> listRoverClustersRecordIterator(final ListRoverClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverClustersRequest.Builder>(){

            @Override
            public ListRoverClustersRequest.Builder get() {
                return ListRoverClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, String>(){

            @Override
            public String apply(ListRoverClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverClustersRequest.Builder>, ListRoverClustersRequest>(){

            @Override
            public ListRoverClustersRequest apply(RequestBuilderAndToken<ListRoverClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverClustersRequest, ListRoverClustersResponse>(){

            @Override
            public ListRoverClustersResponse apply(ListRoverClustersRequest request) {
                return RoverClusterPaginators.this.client.listRoverClusters(request);
            }
        }, (Function)new Function<ListRoverClustersResponse, List<RoverClusterSummary>>(){

            @Override
            public List<RoverClusterSummary> apply(ListRoverClustersResponse response) {
                return response.getRoverClusterCollection().getItems();
            }
        });
    }
}

